/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import java.util.Arrays;
import java.util.Optional;

public class EnumMapper {
    public static <E extends Enum<E>> Optional<E> mapToEnum(String text, Class<E> type) {
        return EnumMapper.mapToEnum2(text, type);
    }

    public static Optional<? extends Enum<?>> mapToEnum2(String text, Class<? extends Enum<?>> type) {
        if (text == null) {
            return Optional.empty();
        }
        String name = text.toUpperCase().replace('-', '_');
        return Arrays.stream(type.getEnumConstants()).filter(it -> it.name().toUpperCase().equals(name)).findFirst();
    }

    public static String toString(Enum<?> en) {
        return en.name().toLowerCase().replace('_', '-');
    }
}

