/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.text.MarkdownFormatter;
import org.opentripplanner.standalone.config.framework.json.EnumMapper;
import org.opentripplanner.util.lang.StringUtils;
import org.opentripplanner.util.time.DurationUtils;

public enum ConfigType {
    BOOLEAN(JsonType.basic, "This is the Boolean JSON type", "true", "false"),
    STRING(JsonType.string, "This is the String JSON type.", "This is a string!"),
    DOUBLE(JsonType.basic, "A decimal floating point _number_. 64 bit.", "3.15"),
    INTEGER(JsonType.basic, "A decimal integer _number_. 32 bit.", "1", "-7", "2100"),
    LONG(JsonType.basic, "A decimal integer _number_. 64 bit.", "-1234567890"),
    ENUM(JsonType.string, "A fixed set of string literals.", "RAIL", "BUS"),
    ENUM_MAP(JsonType.object, "List of key/value pairs, where the key is a enum and the value can be any given type.", "{ 'RAIL: 1.2, 'BUS': 2.3 }"),
    ENUM_SET(JsonType.object, "List of enum string values", "[ 'RAIL', 'TRAM' ]"),
    LOCALE(JsonType.string, "_`Language[\\_country[\\_variant]]`_. A Locale object represents a specific geographical, political, or cultural region. For more information see the [Java Locale](https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/Locale.html).", "en_US", "nn_NO"),
    DATE(JsonType.string, "Local date. The format is _YYYY-MM-DD_ (ISO-8601).", "2020-09-21"),
    DATE_OR_PERIOD(JsonType.string, "A _local date_, or a _period_ relative to today. The local date has the format `YYYY-MM-DD` and the period has the format `PnYnMnD` or `-PnYnMnD` where `n` is a integer number.", "P1Y", "-P3M2D", "P1D"),
    DURATION(JsonType.string, "A _duration_ is a amount of time. The format is `PnDTnHnMnS` or `nDnHnMnS` where `n` is a  integer number. The `D`(days), `H`(hours), `M`(minutes) and `S`(seconds) are not case sensitive.", "3h", "2m", "1d5h2m3s", "-P2dT-1s"),
    REGEXP(JsonType.string, "A regular expression pattern used to match a sting.", "$^", "gtfs", "\\w{3})-.*\\.xml"),
    URI(JsonType.string, "An URI path to a resource like a file or a URL. Relative URIs are resolved relative to the OTP base path.", "http://foo.bar/", "file:///Users/jon/local/file", "graph.obj"),
    TIME_ZONE(JsonType.string, "Time-Zone ID", "UTC", "Europe/Paris", "-05:00"),
    FEED_SCOPED_ID(JsonType.string, "FeedScopedId", "NO:1001", "1:101"),
    LINEAR_FUNCTION(JsonType.string, "A linear function with one input parameter(x) used to calculate a value. Usually used to calculate a limit or cost.", new String[0]),
    MAP(JsonType.object, "List of key/value pairs, where the key is a string and the value can be any given type.", "{ 'one': 1.2, 'two': 2.3 }"),
    OBJECT(JsonType.object, "Config object containing nested elements", "'walk': { 'speed': 1.3, 'reluctance': 5 }"),
    ARRAY(JsonType.array, "Config object containing an array/list of elements", "'array': [ 1, 2, 3 ]");

    private final JsonType type;
    private final String description;
    private final String[] examples;

    private ConfigType(JsonType type, String description, String ... examples) {
        this.type = type;
        this.description = description;
        this.examples = examples;
    }

    public String description() {
        return this.description;
    }

    public String examplesToMarkdown() {
        return Arrays.stream(this.examples).map(StringUtils::quoteReplace).map(this::quote).map(MarkdownFormatter::code).collect(Collectors.joining(", "));
    }

    public String docName() {
        return EnumMapper.toString(this);
    }

    public String quote(@Nonnull Object value) {
        return this.type == JsonType.string ? ConfigType.quoteText(value) : value.toString();
    }

    public boolean isSimple() {
        return this.type == JsonType.basic || this.type == JsonType.string;
    }

    public boolean isComplex() {
        return this.type == JsonType.object || this.type == JsonType.array;
    }

    public boolean isMapOrArray() {
        return EnumSet.of(ARRAY, MAP, ENUM_MAP).contains((Object)this);
    }

    static ConfigType of(Class<?> javaType) {
        if (Boolean.class.isAssignableFrom(javaType)) {
            return BOOLEAN;
        }
        if (Double.class.isAssignableFrom(javaType)) {
            return DOUBLE;
        }
        if (Duration.class.isAssignableFrom(javaType)) {
            return DURATION;
        }
        if (Integer.class.isAssignableFrom(javaType)) {
            return INTEGER;
        }
        if (Long.class.isAssignableFrom(javaType)) {
            return LONG;
        }
        if (String.class.isAssignableFrom(javaType)) {
            return STRING;
        }
        throw new IllegalArgumentException("Type not supported: " + javaType);
    }

    <T> T valueOf(JsonNode node) {
        return (T)(switch (this) {
            case BOOLEAN -> node.asBoolean();
            case DOUBLE -> node.asDouble();
            case INTEGER -> node.asInt();
            case LONG -> node.asLong();
            case STRING -> node.asText();
            case DURATION -> DurationUtils.duration(node.asText());
            default -> throw new IllegalArgumentException("Unsupported element type: " + this);
        });
    }

    private static String quoteText(@Nullable Object text) {
        return text == null ? "" : "\"" + text + "\"";
    }

    private static enum JsonType {
        basic,
        string,
        object,
        array;

    }
}

