/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import java.util.List;
import org.opentripplanner.graph_builder.model.DataSourceConfig;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedParameters;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedParametersBuilder;
import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.standalone.config.buildconfig.NetexConfig;
import org.opentripplanner.standalone.config.buildconfig.TransitFeeds;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class TransitFeedConfig {
    public static TransitFeeds mapTransitFeeds(NodeAdapter root, String parameterName, NetexFeedParameters netexDefaults) {
        List<DataSourceConfig> list = root.of(parameterName).since(OtpVersion.V2_2).summary("Scan for transit data files").description("The transitFeeds section of `build-config.json` allows you to override the default behavior\nof scanning for transit data files in the [base directory](Configuration.md#Base-Directory).\nYou can specify data located outside the local filesystem (including cloud storage services)\nor at various different locations around the local filesystem.\n\nWhen a feed of a particular type (`netex` or `gtfs`) is specified in the transitFeeds\nsection, auto-scanning in the base directory for this feed type will be disabled.\n").asObjects(node -> TransitFeedConfig.mapTransitFeed(node, netexDefaults));
        return new TransitFeeds(TransitFeedConfig.filterListOnSubType(list, GtfsFeedParameters.class), TransitFeedConfig.filterListOnSubType(list, NetexFeedParameters.class));
    }

    private static DataSourceConfig mapTransitFeed(NodeAdapter feedNode, NetexFeedParameters netexDefaults) {
        TransitFeedType type = (TransitFeedType)((Object)feedNode.of("type").since(OtpVersion.V2_2).summary("The feed input format.").asEnum(TransitFeedType.class));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TransitFeedType.GTFS -> TransitFeedConfig.mapGtfsFeed(feedNode);
            case TransitFeedType.NETEX -> NetexConfig.mapNetexFeed(feedNode, netexDefaults);
        };
    }

    private static DataSourceConfig mapGtfsFeed(NodeAdapter node) {
        return new GtfsFeedParametersBuilder().withFeedId(node.of("feedId").since(OtpVersion.NA).summary("The unique ID for this feed. This overrides any feed ID defined within the feed itself.").asString(null)).withSource(node.of("source").since(OtpVersion.NA).summary("The unique URI pointing to the data file.").asUri()).build();
    }

    private static <T> List<T> filterListOnSubType(List<? super T> list, Class<T> type) {
        return list.stream().filter(it -> type.isAssignableFrom(it.getClass())).map(it -> it).toList();
    }

    static enum TransitFeedType {
        GTFS,
        NETEX;

    }
}

