/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.Serializable;
import java.time.Duration;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.TransitRoutingConfig;
import org.opentripplanner.standalone.config.routerconfig.UpdatersConfig;
import org.opentripplanner.standalone.config.routerconfig.VectorTileConfig;
import org.opentripplanner.standalone.config.routerequest.RouteRequestConfig;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.standalone.config.sandbox.TransmodelAPIConfig;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.updater.UpdatersParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterConfig
implements Serializable {
    private static final Duration DEFAULT_STREET_ROUTING_TIMEOUT = Duration.ofSeconds(5L);
    private static final Logger LOG = LoggerFactory.getLogger(RouterConfig.class);
    public static final RouterConfig DEFAULT = new RouterConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private final NodeAdapter root;
    private final String configVersion;
    private final String requestLogFile;
    private final TransmodelAPIConfig transmodelApi;
    private final Duration streetRoutingTimeout;
    private final RouteRequest routingRequestDefaults;
    private final TransitRoutingConfig transitConfig;
    private final UpdatersParameters updatersParameters;
    private final VectorTileConfig vectorTileLayers;
    private final FlexConfig flexConfig;

    public RouterConfig(JsonNode node, String source, boolean logUnusedParams) {
        this(new NodeAdapter(node, source), logUnusedParams);
    }

    RouterConfig(NodeAdapter root, boolean logUnusedParams) {
        this.root = root;
        this.configVersion = root.of("configVersion").since(OtpVersion.V2_1).summary("Deployment version of the *router-config.json*.").description("The config-version is a parameter which each OTP deployment may set to be able to query the\nOTP server and verify that it uses the correct version of the config. The version should be\ninjected into the config in the (continuous) deployment pipeline. How this is done, is up to\nthe deployment.\n\nThe config-version has no effect on OTP, and is provided as is on the API. There is no syntax\nor format check on the version and it can be any string.\n\nBe aware that OTP uses the config embedded in the loaded graph if no new config is provided.\n").asString(null);
        this.requestLogFile = root.of("requestLogFile").since(OtpVersion.V2_0).summary("The path of the log file for the requests.").description("You can log some characteristics of trip planning requests in a file for later analysis. Some\ntransit agencies and operators find this information useful for identifying existing or unmet\ntransportation demand. Logging will be performed only if you specify a log file name in the router\nconfig.\n\nEach line in the resulting log file will look like this:\n\n```\n2016-04-19T18:23:13.486 0:0:0:0:0:0:0:1 ARRIVE 2016-04-07T00:17 WALK,BUS,CABLE_CAR,TRANSIT,BUSISH 45.559737193889966 -122.64999389648438 45.525592487765635 -122.39044189453124 6095 3 5864 3 6215 3\n```\n\nThe fields separated by whitespace are (in order):\n\n1. Date and time the request was received\n2. IP address of the user\n3. Arrive or depart search\n4. The arrival or departure time\n5. A comma-separated list of all transport modes selected\n6. Origin latitude and longitude\n7. Destination latitude and longitude\n\nFinally, for each itinerary returned to the user, there is a travel duration in seconds and the\nnumber of transit vehicles used in that itinerary.\n").asString(null);
        this.transmodelApi = new TransmodelAPIConfig(root.of("transmodelApi").since(OtpVersion.NA).summary("Configuration for the Transmodel GraphQL API.").asObject());
        this.streetRoutingTimeout = RouterConfig.parseStreetRoutingTimeout(root);
        this.transitConfig = new TransitRoutingConfig("transit", root);
        this.routingRequestDefaults = RouteRequestConfig.mapDefaultRouteRequest(root, "routingDefaults");
        this.updatersParameters = new UpdatersConfig(root);
        this.vectorTileLayers = VectorTileConfig.mapVectorTilesParameters(root, "vectorTileLayers");
        this.flexConfig = new FlexConfig(root.of("flex").since(OtpVersion.NA).summary("Configuration for flex routing.").asObject());
        if (logUnusedParams && LOG.isWarnEnabled()) {
            root.logAllUnusedParameters(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public String requestLogFile() {
        return this.requestLogFile;
    }

    public Duration streetRoutingTimeout() {
        return this.streetRoutingTimeout;
    }

    public TransmodelAPIConfig transmodelApi() {
        return this.transmodelApi;
    }

    public RouteRequest routingRequestDefaults() {
        return this.routingRequestDefaults;
    }

    public RaptorTuningParameters raptorTuningParameters() {
        return this.transitConfig;
    }

    public TransitTuningParameters transitTuningParameters() {
        return this.transitConfig;
    }

    public UpdatersParameters updaterConfig() {
        return this.updatersParameters;
    }

    public VectorTilesResource.LayersParameters vectorTileLayers() {
        return this.vectorTileLayers;
    }

    public FlexParameters flexParameters(RoutingPreferences preferences) {
        return this.flexConfig.toFlexParameters(preferences);
    }

    public NodeAdapter asNodeAdapter() {
        return this.root;
    }

    public boolean isDefault() {
        return this.root.isEmpty();
    }

    public String toJson() {
        return this.root.isEmpty() ? "" : this.root.toJson();
    }

    public String toString() {
        return this.root.toPrettyString();
    }

    static Duration parseStreetRoutingTimeout(NodeAdapter adapter) {
        return adapter.of("streetRoutingTimeout").since(OtpVersion.NA).summary("The maximum time a street routing request is allowed to take before returning a timeout.").description("In OTP1 path searches sometimes took a long time to complete. With the new Raptor algorithm this is not\nthe case anymore. The street part of the routing may still take a long time if searching very long\ndistances. You can set the street routing timeout to avoid tying up server resources on pointless\nsearches and ensure that your users receive a timely response. You can also limit the max distance\nto search for WALK, BIKE and CAR. When a search times out, a WARN level log entry is made with\ninformation that can help identify problematic searches and improve our routing methods. There are\nno timeouts for the transit part of the routing search, instead configure a reasonable dynamic\nsearch-window.\n\nThe search aborts after this duration and any paths found are returned to the client.\n").asDuration(DEFAULT_STREET_ROUTING_TIMEOUT);
    }
}

