/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpConfig {
    public static final String CONFIG_VERSION_DESCRIPTION = "The config-version is a parameter which each OTP deployment may set to be able to query the\nOTP server and verify that it uses the correct version of the config. The version should be\ninjected into the config in the (continuous) deployment pipeline. How this is done, is up to\nthe deployment.\n\nThe config-version has no effect on OTP, and is provided as is on the API. There is no syntax\nor format check on the version and it can be any string.\n\nBe aware that OTP uses the config embedded in the loaded graph if no new config is provided.\n";
    private static final Logger LOG = LoggerFactory.getLogger(OtpConfig.class);
    public final NodeAdapter root;
    public final Map<OTPFeature, Boolean> otpFeatures;
    public final String configVersion;

    public OtpConfig(JsonNode otpConfig, String source, boolean logUnusedParams) {
        this.root = new NodeAdapter(otpConfig, source);
        this.configVersion = this.root.of("configVersion").since(OtpVersion.V2_1).summary("Deployment version of the *otp-config.json*.").description(CONFIG_VERSION_DESCRIPTION).asString(null);
        this.otpFeatures = this.root.of("otpFeatures").since(OtpVersion.NA).summary("TODO").asEnumMap(OTPFeature.class, Boolean.class);
        if (logUnusedParams && LOG.isWarnEnabled()) {
            this.root.logAllUnusedParameters(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }
}

