/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vertextype;

import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.StationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitPathwayNodeVertex
extends Vertex {
    private static final Logger LOG = LoggerFactory.getLogger(TransitPathwayNodeVertex.class);
    private static final long serialVersionUID = 1L;
    private final boolean wheelchairEntrance;
    private final PathwayNode node;

    public TransitPathwayNodeVertex(Graph graph, PathwayNode node) {
        super(graph, node.getId().toString(), node.getCoordinate().longitude(), node.getCoordinate().latitude(), node.getName());
        this.node = node;
        this.wheelchairEntrance = node.getWheelchairAccessibility() != Accessibility.NOT_POSSIBLE;
        graph.expandToInclude(node.getCoordinate().longitude(), node.getCoordinate().latitude());
    }

    public boolean isWheelchairEntrance() {
        return this.wheelchairEntrance;
    }

    public PathwayNode getNode() {
        return this.node;
    }

    @Override
    public StationElement getStationElement() {
        return this.node;
    }
}

