/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_rental;

import java.time.Instant;
import java.util.Set;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationUris;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalSystem;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class VehicleRentalVehicle
implements VehicleRentalPlace {
    public FeedScopedId id;
    public I18NString name;
    public double longitude;
    public double latitude;
    public VehicleRentalSystem system;
    public RentalVehicleType vehicleType;
    public VehicleRentalStationUris rentalUris;
    public boolean isReserved = false;
    public boolean isDisabled = false;
    public Instant lastReported;
    public Double currentRangeMeters;
    public VehicleRentalStation station;
    public String pricingPlanId;

    @Override
    public FeedScopedId getId() {
        return this.id;
    }

    @Override
    public String getStationId() {
        return this.getId().getId();
    }

    @Override
    public String getNetwork() {
        return this.getId().getFeedId();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public int getVehiclesAvailable() {
        return 1;
    }

    @Override
    public int getSpacesAvailable() {
        return 0;
    }

    @Override
    public Integer getCapacity() {
        return 0;
    }

    @Override
    public boolean isAllowDropoff() {
        return false;
    }

    @Override
    public boolean isAllowOverloading() {
        return false;
    }

    @Override
    public boolean isAllowPickup() {
        return !this.isDisabled;
    }

    @Override
    public boolean allowPickupNow() {
        return !this.isReserved && !this.isDisabled;
    }

    @Override
    public boolean allowDropoffNow() {
        return false;
    }

    @Override
    public boolean isFloatingVehicle() {
        return true;
    }

    @Override
    public boolean isCarStation() {
        return this.vehicleType.formFactor.equals((Object)RentalVehicleType.FormFactor.CAR);
    }

    @Override
    public Set<RentalVehicleType.FormFactor> getAvailablePickupFormFactors(boolean includeRealtimeAvailability) {
        return Set.of(this.vehicleType.formFactor);
    }

    @Override
    public Set<RentalVehicleType.FormFactor> getAvailableDropoffFormFactors(boolean includeRealtimeAvailability) {
        return Set.of();
    }

    @Override
    public boolean isArrivingInRentalVehicleAtDestinationAllowed() {
        return false;
    }

    @Override
    public boolean isRealTimeData() {
        return true;
    }

    @Override
    public VehicleRentalStationUris getRentalUris() {
        return this.rentalUris;
    }
}

