/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.util.elevation;

public class ToblersHikingFunction {
    private static final double E = -3.5;
    private static final double A = 0.05;
    private static final double C = 1.0 / Math.exp(-0.17500000000000002);
    private final double walkDistMultiplierMaxLimit;

    public ToblersHikingFunction(double walkDistMultiplierMaxLimit) {
        if (walkDistMultiplierMaxLimit < 1.0) {
            throw new IllegalArgumentException("The 'walkDistMultiplierMaxLimit' is " + walkDistMultiplierMaxLimit + ", but must be greater then 1.");
        }
        this.walkDistMultiplierMaxLimit = walkDistMultiplierMaxLimit;
    }

    public double calculateHorizontalWalkingDistanceMultiplier(double dx, double dh) {
        double distanceMultiplier = 1.0 / (C * Math.exp(-3.5 * Math.abs(dh / dx + 0.05)));
        return distanceMultiplier < this.walkDistMultiplierMaxLimit ? distanceMultiplier : this.walkDistMultiplierMaxLimit;
    }
}

