/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.services.notes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.routing.edgetype.TemporaryPartialStreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.services.notes.MatcherAndStreetNote;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.routing.services.notes.StreetNotesSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticStreetNotesSource
implements StreetNotesSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StaticStreetNotesSource.class);
    private final SetMultimap<Edge, MatcherAndStreetNote> notesForEdge = HashMultimap.create();
    private final transient Map<T2<NoteMatcher, StreetNote>, MatcherAndStreetNote> uniqueMatchers = new HashMap<T2<NoteMatcher, StreetNote>, MatcherAndStreetNote>();

    StaticStreetNotesSource() {
    }

    @Override
    public Set<MatcherAndStreetNote> getNotes(Edge edge) {
        Set maas;
        if (edge instanceof TemporaryPartialStreetEdge) {
            edge = ((TemporaryPartialStreetEdge)edge).getParentEdge();
        }
        if ((maas = this.notesForEdge.get((Object)edge)) == null || maas.isEmpty()) {
            return null;
        }
        return maas;
    }

    void addNote(Edge edge, StreetNote note, NoteMatcher matcher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding note {} to {} with matcher {}", new Object[]{note, edge, matcher});
        }
        this.notesForEdge.put((Object)edge, (Object)this.buildMatcherAndAlert(matcher, note));
    }

    void removeNotes(Edge edge) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing notes for edge: {}", (Object)edge);
        }
        this.notesForEdge.removeAll((Object)edge);
    }

    private MatcherAndStreetNote buildMatcherAndAlert(NoteMatcher noteMatcher, StreetNote note) {
        T2<NoteMatcher, StreetNote> key = new T2<NoteMatcher, StreetNote>(noteMatcher, note);
        MatcherAndStreetNote interned = this.uniqueMatchers.get(key);
        if (interned != null) {
            return interned;
        }
        MatcherAndStreetNote ret = new MatcherAndStreetNote(noteMatcher, note);
        this.uniqueMatchers.put(key, ret);
        return ret;
    }
}

