/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.location;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.routing.edgetype.TemporaryEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.location.StreetLocation;
import org.opentripplanner.routing.vertextype.TemporaryVertex;
import org.opentripplanner.transit.model.basic.I18NString;

public final class TemporaryStreetLocation
extends StreetLocation
implements TemporaryVertex {
    private final boolean endVertex;

    public TemporaryStreetLocation(String id, Coordinate nearestPoint, I18NString name, boolean endVertex) {
        super(id, nearestPoint, name);
        this.endVertex = endVertex;
    }

    @Override
    public void addOutgoing(Edge edge) {
        if (edge instanceof TemporaryEdge) {
            if (this.endVertex) {
                throw new UnsupportedOperationException("Can't add outgoing edge to end vertex");
            }
        } else {
            throw new UnsupportedOperationException("Can't add permanent edge to temporary vertex");
        }
        super.addOutgoing(edge);
    }

    @Override
    public void addIncoming(Edge edge) {
        if (edge instanceof TemporaryEdge) {
            if (!this.endVertex) {
                throw new UnsupportedOperationException("Can't add incoming edge to start vertex");
            }
        } else {
            throw new UnsupportedOperationException("Can't add permanent edge to temporary vertex");
        }
        super.addIncoming(edge);
    }

    @Override
    public boolean isEndVertex() {
        return this.endVertex;
    }
}

