/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.routing.algorithm.astar.AStarBuilder;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.core.TemporaryVerticesContainer;
import org.opentripplanner.routing.error.PathNotFoundException;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.PathComparator;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPathFinder {
    private static final Logger LOG = LoggerFactory.getLogger(GraphPathFinder.class);
    @Nullable
    private final TraverseVisitor traverseVisitor;
    private final Duration streetRoutingTimeout;
    private final DataOverlayContext dataOverlayContext;

    public GraphPathFinder(@Nullable TraverseVisitor traverseVisitor, Duration streetRoutingTimeout) {
        this(traverseVisitor, streetRoutingTimeout, null);
    }

    public GraphPathFinder(@Nullable TraverseVisitor traverseVisitor, Duration streetRoutingTimeout, @Nullable DataOverlayContext dataOverlayContext) {
        this.traverseVisitor = traverseVisitor;
        this.streetRoutingTimeout = streetRoutingTimeout;
        this.dataOverlayContext = dataOverlayContext;
    }

    public List<GraphPath> getPaths(RouteRequest request, Set<Vertex> from, Set<Vertex> to) {
        StreetPreferences preferences = request.preferences().street();
        AStarBuilder aStar = AStarBuilder.oneToOneMaxDuration(preferences.maxDirectDuration().valueOf(request.journey().direct().mode())).setDominanceFunction(new DominanceFunction.MinimumWeight()).setRequest(request).setStreetRequest(request.journey().direct()).setFrom(from).setTo(to).setDataOverlayContext(this.dataOverlayContext).setTimeout(this.streetRoutingTimeout);
        if (this.traverseVisitor != null) {
            aStar.setTraverseVisitor(this.traverseVisitor);
        }
        LOG.debug("rreq={}", (Object)request);
        long searchBeginTime = System.currentTimeMillis();
        LOG.debug("BEGIN SEARCH");
        List<GraphPath> paths = aStar.getPathsToTarget();
        LOG.debug("we have {} paths", (Object)paths.size());
        LOG.debug("END SEARCH ({} msec)", (Object)(System.currentTimeMillis() - searchBeginTime));
        paths.sort(new PathComparator(request.arriveBy()));
        return paths;
    }

    public List<GraphPath> graphPathFinderEntryPoint(RouteRequest request, TemporaryVerticesContainer vertexContainer) {
        return this.graphPathFinderEntryPoint(request, vertexContainer.getFromVertices(), vertexContainer.getToVertices());
    }

    public List<GraphPath> graphPathFinderEntryPoint(RouteRequest request, Set<Vertex> from, Set<Vertex> to) {
        Instant reqTime = request.dateTime().truncatedTo(ChronoUnit.SECONDS);
        List<GraphPath> paths = this.getPaths(request, from, to);
        if (paths != null) {
            Iterator<GraphPath> gpi = paths.iterator();
            while (gpi.hasNext()) {
                GraphPath graphPath = gpi.next();
                if (request.arriveBy()) {
                    if (!graphPath.states.getLast().getTime().isAfter(reqTime)) continue;
                    LOG.error("A graph path arrives after the requested time. This implies a bug.");
                    gpi.remove();
                    continue;
                }
                if (!graphPath.states.getFirst().getTime().isBefore(reqTime)) continue;
                LOG.error("A graph path leaves before the requested time. This implies a bug.");
                gpi.remove();
            }
        }
        if (paths == null || paths.isEmpty()) {
            LOG.debug("Path not found: {} : {}", (Object)request.from(), (Object)request.to());
            throw new PathNotFoundException();
        }
        return paths;
    }
}

