/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.common.TurnRestriction;
import org.opentripplanner.common.geometry.CompactElevationProfile;
import org.opentripplanner.common.geometry.GraphUtils;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayParameterBindings;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.services.RealtimeVehiclePositionService;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.util.ElevationUtils;
import org.opentripplanner.util.WorldEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Graph.class);
    public final StreetNotesService streetNotesService = new StreetNotesService();
    private final Map<String, Vertex> vertices = new ConcurrentHashMap<String, Vertex>();
    public final transient Deduplicator deduplicator;
    public final Instant buildTime = Instant.now();
    @Nullable
    private final OpeningHoursCalendarService openingHoursCalendarService;
    private transient StreetVertexIndex streetIndex;
    private WorldEnvelope envelope = null;
    private Geometry convexHull = null;
    public Preferences preferences = null;
    public boolean hasBikeSharing = false;
    public boolean hasParkRide = false;
    public boolean hasBikeRide = false;
    public boolean hasStreets = false;
    public boolean hasLinkedBikeParks = false;
    public Double ellipsoidToGeoidDifference = 0.0;
    public boolean hasElevation = false;
    public Double minElevation = null;
    public Double maxElevation = null;
    private double distanceBetweenElevationSamples;
    private transient RealtimeVehiclePositionService vehiclePositionService;
    private final VehicleRentalStationService vehicleRentalStationService = new VehicleRentalStationService();
    private final VehicleParkingService vehicleParkingService = new VehicleParkingService();
    private FareService fareService;
    public long nextSplitNumber = 0L;
    public DataOverlayParameterBindings dataOverlayParameterBindings;
    private LuceneIndex luceneIndex;

    @Inject
    public Graph(Deduplicator deduplicator, @Nullable OpeningHoursCalendarService openingHoursCalendarService) {
        this.deduplicator = deduplicator;
        this.openingHoursCalendarService = openingHoursCalendarService;
    }

    public Graph(Deduplicator deduplicator) {
        this(deduplicator, null);
    }

    public Graph() {
        this(new Deduplicator(), null);
    }

    public void addVertex(Vertex v) {
        Vertex old = this.vertices.put(v.getLabel(), v);
        if (old != null) {
            if (old == v) {
                LOG.error("repeatedly added the same vertex: {}", (Object)v);
            } else {
                LOG.error("duplicate vertex label in graph (added vertex to graph anyway): {}", (Object)v);
            }
        }
    }

    public void removeEdge(Edge e) {
        if (e != null) {
            this.streetNotesService.removeStaticNotes(e);
            if (e instanceof StreetEdge) {
                ((StreetEdge)e).removeAllTurnRestrictions();
            }
            if (e.fromv != null) {
                e.fromv.getIncoming().stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).forEach(otherEdge -> {
                    for (TurnRestriction turnRestriction : otherEdge.getTurnRestrictions()) {
                        if (turnRestriction.to != e) continue;
                        otherEdge.removeTurnRestriction(turnRestriction);
                    }
                });
                e.fromv.removeOutgoing(e);
                e.fromv = null;
            }
            if (e.tov != null) {
                e.tov.removeIncoming(e);
                e.tov = null;
            }
        }
    }

    @VisibleForTesting
    public Vertex getVertex(String label) {
        return this.vertices.get(label);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public <T extends Vertex> List<T> getVerticesOfType(Class<T> cls) {
        return this.getVertices().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public TransitStopVertex getStopVertexForStopId(FeedScopedId id) {
        return this.streetIndex.findTransitStopVertices(id);
    }

    public Collection<Edge> getEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Vertex v : this.getVertices()) {
            edges.addAll(v.getOutgoing());
        }
        return edges;
    }

    public <T extends Edge> List<T> getEdgesOfType(Class<T> cls) {
        return this.getEdges().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public Collection<StreetEdge> getStreetEdges() {
        return this.getEdgesOfType(StreetEdge.class);
    }

    public boolean containsVertex(Vertex v) {
        return v != null && this.vertices.get(v.getLabel()) == v;
    }

    public void remove(Vertex vertex) {
        this.vertices.remove(vertex.getLabel());
    }

    public void removeIfUnconnected(Vertex v) {
        if (v.getDegreeIn() == 0 && v.getDegreeOut() == 0) {
            this.remove(v);
        }
    }

    public Envelope getExtent() {
        Envelope env = new Envelope();
        for (Vertex v : this.getVertices()) {
            env.expandToInclude(v.getCoordinate());
        }
        return env;
    }

    public int countVertices() {
        return this.vertices.size();
    }

    public int countEdges() {
        int ne = 0;
        for (Vertex v : this.getVertices()) {
            ne += v.getDegreeOut();
        }
        return ne;
    }

    public void index(StopModel stopModel) {
        LOG.info("Index street model...");
        this.streetIndex = new StreetVertexIndex(this, stopModel);
        LOG.info("Index street model complete.");
    }

    @Nullable
    public OpeningHoursCalendarService getOpeningHoursCalendarService() {
        return this.openingHoursCalendarService;
    }

    public StreetVertexIndex getStreetIndex() {
        return this.streetIndex;
    }

    public StreetVertexIndex getStreetIndexSafe(StopModel stopModel) {
        this.indexIfNotIndexed(stopModel);
        return this.streetIndex;
    }

    public VertexLinker getLinker() {
        return this.streetIndex.getVertexLinker();
    }

    public VertexLinker getLinkerSafe(StopModel stopModel) {
        this.indexIfNotIndexed(stopModel);
        return this.streetIndex.getVertexLinker();
    }

    public void calculateEnvelope() {
        this.envelope = new WorldEnvelope();
        for (Vertex v : this.getVertices()) {
            Coordinate c = v.getCoordinate();
            this.envelope.expandToInclude(c);
        }
    }

    public void calculateConvexHull() {
        this.convexHull = GraphUtils.makeConvexHull(this);
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    public void expandToInclude(double x, double y) {
        if (this.envelope == null) {
            this.calculateEnvelope();
        }
        this.envelope.expandToInclude(x, y);
    }

    public void initEllipsoidToGeoidDifference() {
        try {
            WorldEnvelope env = this.getEnvelope();
            double lat = (env.getLowerLeftLatitude() + env.getUpperRightLatitude()) / 2.0;
            double lon = (env.getLowerLeftLongitude() + env.getUpperRightLongitude()) / 2.0;
            this.ellipsoidToGeoidDifference = ElevationUtils.computeEllipsoidToGeoidDifference(lat, lon);
            LOG.info("Computed ellipsoid/geoid offset at (" + lat + ", " + lon + ") as " + this.ellipsoidToGeoidDifference);
        }
        catch (Exception e) {
            LOG.error("Error computing ellipsoid/geoid difference");
        }
    }

    public WorldEnvelope getEnvelope() {
        return this.envelope;
    }

    public double getDistanceBetweenElevationSamples() {
        return this.distanceBetweenElevationSamples;
    }

    public void setDistanceBetweenElevationSamples(double distanceBetweenElevationSamples) {
        this.distanceBetweenElevationSamples = distanceBetweenElevationSamples;
        CompactElevationProfile.setDistanceBetweenSamplesM(distanceBetweenElevationSamples);
    }

    public RealtimeVehiclePositionService getVehiclePositionService() {
        if (this.vehiclePositionService == null) {
            this.vehiclePositionService = new RealtimeVehiclePositionService();
        }
        return this.vehiclePositionService;
    }

    public VehicleRentalStationService getVehicleRentalStationService() {
        return this.vehicleRentalStationService;
    }

    public VehicleParkingService getVehicleParkingService() {
        return this.vehicleParkingService;
    }

    public FareService getFareService() {
        return this.fareService;
    }

    public void setFareService(FareService fareService) {
        this.fareService = fareService;
    }

    public LuceneIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public void setLuceneIndex(LuceneIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    private void indexIfNotIndexed(StopModel stopModel) {
        if (this.streetIndex == null) {
            this.index(stopModel);
        }
    }
}

