/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;
import org.opentripplanner.transit.model.basic.I18NString;

public class VehicleRentalEdge
extends Edge {
    public RentalVehicleType.FormFactor formFactor;

    public VehicleRentalEdge(VehicleRentalPlaceVertex vertex, RentalVehicleType.FormFactor formFactor) {
        super(vertex, vertex);
        this.formFactor = formFactor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public State traverse(State s0) {
        boolean pickedUp;
        RoutingPreferences preferences;
        StateEditor s1;
        block27: {
            boolean realtimeAvailability;
            String network;
            VehicleRentalPlace station;
            Set<RentalVehicleType.FormFactor> allowedRentalFormFactors;
            block26: {
                if (!s0.getRequest().mode().includesRenting()) {
                    return null;
                }
                allowedRentalFormFactors = VehicleRentalEdge.allowedModes(s0.getRequest().mode());
                if (!allowedRentalFormFactors.isEmpty() && !allowedRentalFormFactors.contains((Object)this.formFactor)) {
                    return null;
                }
                s1 = s0.edit(this);
                VehicleRentalPlaceVertex stationVertex = (VehicleRentalPlaceVertex)this.tov;
                station = stationVertex.getStation();
                network = station.getNetwork();
                preferences = s0.getPreferences();
                realtimeAvailability = preferences.rental().useAvailabilityInformation();
                if (station.networkIsNotAllowed(s0.getRequest().rental())) {
                    return null;
                }
                if (!s0.getRequest().arriveBy()) break block26;
                switch (s0.getVehicleRentalState()) {
                    case BEFORE_RENTING: {
                        return null;
                    }
                    case HAVE_RENTED: {
                        if (!(!realtimeAvailability || station.allowDropoffNow() && station.getAvailableDropoffFormFactors(true).contains((Object)this.formFactor))) {
                            return null;
                        }
                        s1.dropOffRentedVehicleAtStation(this.formFactor, network, true);
                        pickedUp = false;
                        break block27;
                    }
                    case RENTING_FLOATING: {
                        if (realtimeAvailability && !station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor)) {
                            return null;
                        }
                        if (!station.isFloatingVehicle()) return null;
                        s1.beginFloatingVehicleRenting(this.formFactor, network, true);
                        pickedUp = true;
                        break block27;
                    }
                    case RENTING_FROM_STATION: {
                        if (!(!realtimeAvailability || station.allowPickupNow() && station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor))) {
                            return null;
                        }
                        if (s0.mayKeepRentedVehicleAtDestination() && !station.isArrivingInRentalVehicleAtDestinationAllowed()) {
                            return null;
                        }
                        if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                            return null;
                        }
                        s1.beginVehicleRentingAtStation(this.formFactor, network, false, true);
                        pickedUp = true;
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (s0.getVehicleRentalState()) {
                case BEFORE_RENTING: {
                    if (!(!realtimeAvailability || station.allowPickupNow() && station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor))) {
                        return null;
                    }
                    if (station.isFloatingVehicle()) {
                        s1.beginFloatingVehicleRenting(this.formFactor, network, false);
                    } else {
                        boolean mayKeep = s0.getRequest().rental().allowArrivingInRentedVehicleAtDestination() && station.isArrivingInRentalVehicleAtDestinationAllowed();
                        s1.beginVehicleRentingAtStation(this.formFactor, network, mayKeep, false);
                    }
                    pickedUp = true;
                    break;
                }
                case HAVE_RENTED: {
                    return null;
                }
                case RENTING_FLOATING: 
                case RENTING_FROM_STATION: {
                    if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                        return null;
                    }
                    if (!(!realtimeAvailability || station.allowDropoffNow() && station.getAvailableDropoffFormFactors(true).contains((Object)this.formFactor))) {
                        return null;
                    }
                    if (!allowedRentalFormFactors.isEmpty()) {
                        if (station.getAvailableDropoffFormFactors(realtimeAvailability).stream().noneMatch(allowedRentalFormFactors::contains)) {
                            return null;
                        }
                    }
                    s1.dropOffRentedVehicleAtStation(this.formFactor, network, false);
                    pickedUp = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        s1.incrementWeight(pickedUp ? (double)preferences.rental().pickupCost() : (double)preferences.rental().dropoffCost());
        s1.incrementTimeInSeconds(pickedUp ? preferences.rental().pickupTime() : preferences.rental().dropoffTime());
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    private boolean hasCompatibleNetworks(String stationNetwork, String rentedNetwork) {
        if (rentedNetwork == null) {
            return true;
        }
        return rentedNetwork.equals(stationNetwork);
    }

    private static Set<RentalVehicleType.FormFactor> allowedModes(StreetMode streetMode) {
        return switch (streetMode) {
            case StreetMode.BIKE_RENTAL -> Set.of(RentalVehicleType.FormFactor.BICYCLE);
            case StreetMode.SCOOTER_RENTAL -> Set.of(RentalVehicleType.FormFactor.SCOOTER);
            case StreetMode.CAR_RENTAL -> Set.of(RentalVehicleType.FormFactor.CAR);
            default -> Set.of();
        };
    }
}

