/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.TemporaryEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.transit.model.basic.I18NString;

public final class TemporaryPartialStreetEdge
extends StreetEdge
implements TemporaryEdge {
    private final StreetEdge parentEdge;
    private final LineString geometry;

    public TemporaryPartialStreetEdge(StreetEdge parentEdge, StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, double length) {
        super(v1, v2, geometry, name, length, parentEdge.getPermission(), false);
        this.parentEdge = parentEdge;
        this.geometry = super.getGeometry();
    }

    TemporaryPartialStreetEdge(StreetEdge parentEdge, StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, boolean back) {
        super(v1, v2, geometry, name, parentEdge.getPermission(), back);
        this.parentEdge = parentEdge;
        this.geometry = super.getGeometry();
    }

    @Override
    public boolean isEquivalentTo(Edge e) {
        return e == this || e == this.parentEdge;
    }

    @Override
    public boolean isReverseOf(Edge e) {
        Edge other = e;
        if (e instanceof TemporaryPartialStreetEdge) {
            other = ((TemporaryPartialStreetEdge)e).parentEdge;
        }
        return this.parentEdge.isReverseOf(other);
    }

    public boolean isTrivial() {
        Coordinate fromCoord = this.getFromVertex().getCoordinate();
        Coordinate toCoord = this.getToVertex().getCoordinate();
        return fromCoord.equals((Object)toCoord);
    }

    public StreetEdge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public String toString() {
        return "TemporaryPartialStreetEdge(" + this.getDefaultName() + ", " + this.getFromVertex() + " -> " + this.getToVertex() + " length=" + this.getDistanceMeters() + " carSpeed=" + this.getCarSpeed() + " parentEdge=" + this.parentEdge + ")";
    }

    @Override
    public boolean isRoundabout() {
        return this.parentEdge.isRoundabout();
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }

    @Override
    public int getInAngle() {
        return this.parentEdge.getInAngle();
    }

    @Override
    public int getOutAngle() {
        return this.parentEdge.getInAngle();
    }
}

