/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.edgetype.BikeWalkableEdge;
import org.opentripplanner.routing.edgetype.ElevatorEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public class ElevatorBoardEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final LineString geometry;

    public ElevatorBoardEdge(ElevatorOffboardVertex from, ElevatorOnboardVertex to) {
        super(from, to);
        this.geometry = GeometryUtils.makeLineString(List.of(new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())));
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("from", this.fromv).addObj("to", this.tov).toString();
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        if (s1 == null) {
            return null;
        }
        StreetPreferences streetPreferences = s0.getPreferences().street();
        s1.incrementWeight(streetPreferences.elevator().boardCost());
        s1.incrementTimeInSeconds(streetPreferences.elevator().boardTime());
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return new NonLocalizedString("Elevator");
    }

    @Override
    public boolean hasBogusName() {
        return true;
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

