/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.edgetype.BikeWalkableEdge;
import org.opentripplanner.routing.edgetype.ElevatorEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.util.geometry.GeometryUtils;

public class ElevatorAlightEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final I18NString level;
    private final LineString the_geom;

    public ElevatorAlightEdge(ElevatorOnboardVertex from, ElevatorOffboardVertex to, I18NString level) {
        super(from, to);
        this.level = level;
        Coordinate[] coords = new Coordinate[]{new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())};
        this.the_geom = GeometryUtils.getGeometryFactory().createLineString(coords);
    }

    @Override
    public String toString() {
        return "ElevatorAlightEdge(" + this.fromv + " -> " + this.tov + ")";
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        s1.incrementWeight(1.0);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.level;
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return this.the_geom;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

