/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core.intersection_model;

import java.io.Serializable;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.intersection_model.AbstractIntersectionTraversalCalculator;
import org.opentripplanner.routing.core.intersection_model.DrivingDirection;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.vertextype.IntersectionVertex;

public class SimpleIntersectionTraversalCalculator
extends AbstractIntersectionTraversalCalculator
implements Serializable {
    private final DrivingDirection drivingDirection;
    private final double acrossTrafficBicycleTurnMultiplier = this.getSafeBicycleTurnModifier() * 3.0;

    public SimpleIntersectionTraversalCalculator(DrivingDirection drivingDirection) {
        this.drivingDirection = drivingDirection;
    }

    @Override
    public double computeTraversalDuration(IntersectionVertex v, StreetEdge from, StreetEdge to, TraverseMode mode, float fromSpeed, float toSpeed) {
        if (v.inferredFreeFlowing()) {
            return 0.0;
        }
        if (mode.isDriving()) {
            return this.computeDrivingTraversalDuration(v, from, to);
        }
        if (mode.isCycling()) {
            return this.computeCyclingTraversalDuration(from, to, toSpeed);
        }
        return this.computeNonDrivingTraversalDuration(from, to, toSpeed);
    }

    public int getMinRightTurnAngle() {
        return 45;
    }

    public int getMaxRightTurnAngle() {
        return 135;
    }

    public int getMinLeftTurnAngle() {
        return 225;
    }

    public int getMaxLeftTurnAngle() {
        return 315;
    }

    public double getExpectedRightAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedStraightAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedLeftAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedRightNoLightTimeSec() {
        return 8.0;
    }

    public double getExpectedStraightNoLightTimeSec() {
        return 5.0;
    }

    public double getExpectedLeftNoLightTimeSec() {
        return 8.0;
    }

    public double getSafeBicycleTurnModifier() {
        return 5.0;
    }

    public double getAcrossTrafficBicycleTurnMultiplier() {
        return this.acrossTrafficBicycleTurnMultiplier;
    }

    protected boolean isSafeTurn(int turnAngle) {
        return switch (this.drivingDirection) {
            default -> throw new IncompatibleClassChangeError();
            case DrivingDirection.RIGHT -> this.isRightTurn(turnAngle);
            case DrivingDirection.LEFT -> this.isLeftTurn(turnAngle);
        };
    }

    protected boolean isTurnAcrossTraffic(int turnAngle) {
        return switch (this.drivingDirection) {
            default -> throw new IncompatibleClassChangeError();
            case DrivingDirection.RIGHT -> this.isLeftTurn(turnAngle);
            case DrivingDirection.LEFT -> this.isRightTurn(turnAngle);
        };
    }

    private double computeDrivingTraversalDuration(IntersectionVertex v, StreetEdge from, StreetEdge to) {
        int turnAngle = this.calculateTurnAngle(from, to);
        if (v.trafficLight) {
            if (this.isSafeTurn(turnAngle)) {
                return this.getExpectedRightAtLightTimeSec();
            }
            if (this.isTurnAcrossTraffic(turnAngle)) {
                return this.getExpectedLeftAtLightTimeSec();
            }
            return this.getExpectedStraightAtLightTimeSec();
        }
        if (from.getCarSpeed() > 25.0f && to.getCarSpeed() > 25.0f) {
            return 0.0;
        }
        if (this.isSafeTurn(turnAngle)) {
            return this.getExpectedRightNoLightTimeSec();
        }
        if (this.isTurnAcrossTraffic(turnAngle)) {
            return this.getExpectedLeftNoLightTimeSec();
        }
        return this.getExpectedStraightNoLightTimeSec();
    }

    private double computeCyclingTraversalDuration(StreetEdge from, StreetEdge to, float toSpeed) {
        int turnAngle = this.calculateTurnAngle(from, to);
        double baseDuration = this.computeNonDrivingTraversalDuration(from, to, toSpeed);
        if (this.isTurnAcrossTraffic(turnAngle)) {
            return baseDuration * this.getAcrossTrafficBicycleTurnMultiplier();
        }
        if (this.isSafeTurn(turnAngle)) {
            return baseDuration * this.getSafeBicycleTurnModifier();
        }
        return baseDuration;
    }

    private boolean isLeftTurn(int turnAngle) {
        return turnAngle >= this.getMinLeftTurnAngle() && turnAngle < this.getMaxLeftTurnAngle();
    }

    private boolean isRightTurn(int turnAngle) {
        return turnAngle >= this.getMinRightTurnAngle() && turnAngle < this.getMaxRightTurnAngle();
    }
}

