/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.ext.fares.model.LegProducts;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareComponent;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.util.lang.ToStringBuilder;

public class ItineraryFares {
    private final HashMap<FareType, List<FareComponent>> details = new HashMap();
    private final Set<FareProduct> itineraryProducts = new HashSet<FareProduct>();
    private final Multimap<Leg, FareProduct> legProducts = ArrayListMultimap.create();
    private HashMap<FareType, Money> fare = new HashMap();

    public ItineraryFares(ItineraryFares aFare) {
        if (aFare != null) {
            this.fare.putAll(aFare.fare);
        }
    }

    public ItineraryFares() {
    }

    public static ItineraryFares empty() {
        return new ItineraryFares();
    }

    public Set<FareProduct> getItineraryProducts() {
        return Set.copyOf(this.itineraryProducts);
    }

    public Multimap<Leg, FareProduct> getLegProducts() {
        return ImmutableMultimap.copyOf(this.legProducts);
    }

    public void addFare(FareType fareType, Money money) {
        this.fare.put(fareType, money);
    }

    public void addFareDetails(FareType fareType, List<FareComponent> newDetails) {
        this.details.put(fareType, newDetails);
    }

    public void addItineraryProducts(Collection<FareProduct> products) {
        this.itineraryProducts.addAll(products);
    }

    public Money getFare(FareType type) {
        return this.fare.get(type);
    }

    public List<FareComponent> getDetails(FareType type) {
        return this.details.getOrDefault(type, List.of());
    }

    public Set<FareType> getTypes() {
        return this.fare.keySet();
    }

    public int hashCode() {
        return Objects.hash(this.fare, this.details, this.itineraryProducts, this.legProducts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItineraryFares fare1 = (ItineraryFares)o;
        return Objects.equals(this.details, fare1.details) && Objects.equals(this.itineraryProducts, fare1.itineraryProducts) && Objects.equals(this.legProducts, fare1.legProducts);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("details", this.details).toString();
    }

    public void addLegProducts(Collection<LegProducts> legProducts) {
        legProducts.forEach(lp -> this.legProducts.putAll((Object)lp.leg(), lp.products().stream().map(LegProducts.ProductWithTransfer::product).toList()));
    }
}

