/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.response;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import org.opentripplanner.util.lang.ToStringBuilder;

public class TripSearchMetadata {
    public Duration searchWindowUsed;
    @Deprecated
    public Instant nextDateTime;
    @Deprecated
    public Instant prevDateTime;

    private TripSearchMetadata(Duration searchWindowUsed, Instant prevDateTime, Instant nextDateTime) {
        this.searchWindowUsed = searchWindowUsed;
        this.nextDateTime = nextDateTime;
        this.prevDateTime = prevDateTime;
    }

    public static TripSearchMetadata createForArriveBy(Instant reqTime, int searchWindowUsed, @Nullable Instant previousTimeInclusive) {
        Instant prevDateTime = previousTimeInclusive == null ? reqTime.minusSeconds(searchWindowUsed) : previousTimeInclusive.minusSeconds(1L).truncatedTo(ChronoUnit.MINUTES).plusSeconds(60L);
        return new TripSearchMetadata(Duration.ofSeconds(searchWindowUsed), prevDateTime, reqTime.plusSeconds(searchWindowUsed));
    }

    public static TripSearchMetadata createForDepartAfter(Instant reqTime, int searchWindowUsed, Instant nextDateTimeExcusive) {
        Instant nextDateTime = nextDateTimeExcusive == null ? reqTime.plusSeconds(searchWindowUsed) : nextDateTimeExcusive.truncatedTo(ChronoUnit.MINUTES);
        return new TripSearchMetadata(Duration.ofSeconds(searchWindowUsed), reqTime.minusSeconds(searchWindowUsed), nextDateTime);
    }

    public String toString() {
        return ToStringBuilder.of(TripSearchMetadata.class).addDuration("searchWindowUsed", this.searchWindowUsed).addObj("nextDateTime", this.nextDateTime).addObj("prevDateTime", this.prevDateTime).toString();
    }
}

