/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.core.RouteMatcher;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class TransitRequest
implements Cloneable,
Serializable {
    private List<MainAndSubMode> modes = MainAndSubMode.all();
    private List<FeedScopedId> whiteListedAgencies = List.of();
    private List<FeedScopedId> bannedAgencies = List.of();
    @Deprecated
    private List<FeedScopedId> preferredAgencies = List.of();
    private List<FeedScopedId> unpreferredAgencies = List.of();
    private RouteMatcher whiteListedRoutes = RouteMatcher.emptyMatcher();
    private RouteMatcher bannedRoutes = RouteMatcher.emptyMatcher();
    @Deprecated
    private List<FeedScopedId> preferredRoutes = List.of();
    private List<FeedScopedId> unpreferredRoutes = List.of();
    private List<FeedScopedId> bannedTrips = List.of();
    private DebugRaptor raptorDebugging = new DebugRaptor();

    public void setModes(List<MainAndSubMode> modes) {
        this.modes = modes;
    }

    public List<MainAndSubMode> modes() {
        return this.modes;
    }

    public void setWhiteListedAgenciesFromSting(String s) {
        if (!s.isEmpty()) {
            this.whiteListedAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setWhiteListedAgencies(List<FeedScopedId> whiteListedAgencies) {
        this.whiteListedAgencies = whiteListedAgencies;
    }

    public List<FeedScopedId> whiteListedAgencies() {
        return this.whiteListedAgencies;
    }

    public void setBannedAgenciesFromSting(String s) {
        if (!s.isEmpty()) {
            this.bannedAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setBannedAgencies(List<FeedScopedId> bannedAgencies) {
        this.bannedAgencies = bannedAgencies;
    }

    public List<FeedScopedId> bannedAgencies() {
        return this.bannedAgencies;
    }

    @Deprecated
    public void setPreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.preferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    @Deprecated
    public void setPreferredAgencies(List<FeedScopedId> preferredAgencies) {
        this.preferredAgencies = preferredAgencies;
    }

    @Deprecated
    public List<FeedScopedId> preferredAgencies() {
        return this.preferredAgencies;
    }

    public void setUnpreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.unpreferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setUnpreferredAgencies(List<FeedScopedId> unpreferredAgencies) {
        this.unpreferredAgencies = unpreferredAgencies;
    }

    public List<FeedScopedId> unpreferredAgencies() {
        return this.unpreferredAgencies;
    }

    public void setWhiteListedRoutesFromString(String s) {
        this.whiteListedRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setWhiteListedRoutes(RouteMatcher whiteListedRoutes) {
        this.whiteListedRoutes = whiteListedRoutes;
    }

    public RouteMatcher whiteListedRoutes() {
        return this.whiteListedRoutes;
    }

    public void setBannedRoutesFromString(String s) {
        this.bannedRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setBannedRoutes(RouteMatcher bannedRoutes) {
        this.bannedRoutes = bannedRoutes;
    }

    public RouteMatcher bannedRoutes() {
        return this.bannedRoutes;
    }

    @Deprecated
    public void setPreferredRoutesFromString(String s) {
        this.preferredRoutes = !s.isEmpty() ? List.copyOf(FeedScopedId.parseListOfIds(s)) : List.of();
    }

    @Deprecated
    public void setPreferredRoutes(List<FeedScopedId> preferredRoutes) {
        this.preferredRoutes = preferredRoutes;
    }

    @Deprecated
    public List<FeedScopedId> preferredRoutes() {
        return this.preferredRoutes;
    }

    public void setUnpreferredRoutesFromString(String s) {
        this.unpreferredRoutes = !s.isEmpty() ? List.copyOf(FeedScopedId.parseListOfIds(s)) : List.of();
    }

    public void setUnpreferredRoutes(List<FeedScopedId> unpreferredRoutes) {
        this.unpreferredRoutes = unpreferredRoutes;
    }

    public List<FeedScopedId> unpreferredRoutes() {
        return this.unpreferredRoutes;
    }

    public void setBannedTripsFromString(String ids) {
        if (!ids.isEmpty()) {
            this.bannedTrips = FeedScopedId.parseListOfIds(ids);
        }
    }

    public void setBannedTrips(List<FeedScopedId> bannedTrips) {
        this.bannedTrips = bannedTrips;
    }

    public List<FeedScopedId> bannedTrips() {
        return this.bannedTrips;
    }

    public void setRaptorDebugging(DebugRaptor raptorDebugging) {
        this.raptorDebugging = raptorDebugging;
    }

    public DebugRaptor raptorDebugging() {
        return this.raptorDebugging;
    }

    public TransitRequest clone() {
        try {
            TransitRequest clone = (TransitRequest)super.clone();
            clone.modes = new ArrayList<MainAndSubMode>(this.modes);
            clone.whiteListedAgencies = List.copyOf(this.whiteListedAgencies);
            clone.bannedAgencies = List.copyOf(this.bannedAgencies);
            clone.preferredAgencies = List.copyOf(this.preferredAgencies);
            clone.unpreferredAgencies = List.copyOf(this.unpreferredAgencies);
            clone.whiteListedRoutes = this.whiteListedRoutes.clone();
            clone.bannedRoutes = this.bannedRoutes.clone();
            clone.preferredRoutes = List.copyOf(this.preferredRoutes);
            clone.unpreferredRoutes = List.copyOf(this.unpreferredRoutes);
            clone.bannedTrips = List.copyOf(this.bannedTrips);
            clone.raptorDebugging = new DebugRaptor(this.raptorDebugging);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

