/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class WalkPreferences
implements Serializable {
    public static final WalkPreferences DEFAULT = new WalkPreferences();
    private final double speed;
    private final double reluctance;
    private final int boardCost;
    private final double stairsReluctance;
    private final double stairsTimeFactor;
    private final double safetyFactor;

    private WalkPreferences() {
        this.speed = 1.33;
        this.reluctance = 2.0;
        this.boardCost = 600;
        this.stairsReluctance = 2.0;
        this.stairsTimeFactor = 3.0;
        this.safetyFactor = 1.0;
    }

    private WalkPreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.boardCost = Units.cost(builder.boardCost);
        this.stairsReluctance = Units.reluctance(builder.stairsReluctance);
        this.stairsTimeFactor = Units.reluctance(builder.stairsTimeFactor);
        this.safetyFactor = Units.reluctance(builder.safetyFactor);
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int boardCost() {
        return this.boardCost;
    }

    public double stairsReluctance() {
        return this.stairsReluctance;
    }

    public double stairsTimeFactor() {
        return this.stairsTimeFactor;
    }

    public double safetyFactor() {
        return this.safetyFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalkPreferences that = (WalkPreferences)o;
        return DoubleUtils.doubleEquals(that.speed, this.speed) && DoubleUtils.doubleEquals(that.reluctance, this.reluctance) && this.boardCost == that.boardCost && DoubleUtils.doubleEquals(that.stairsReluctance, this.stairsReluctance) && DoubleUtils.doubleEquals(that.stairsTimeFactor, this.stairsTimeFactor) && DoubleUtils.doubleEquals(that.safetyFactor, this.safetyFactor);
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.reluctance, this.boardCost, this.stairsReluctance, this.stairsTimeFactor, this.safetyFactor);
    }

    public String toString() {
        return ToStringBuilder.of(WalkPreferences.class).addNum("speed", (Number)this.speed, WalkPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, WalkPreferences.DEFAULT.reluctance).addNum("boardCost", (Number)this.boardCost, WalkPreferences.DEFAULT.boardCost).addNum("stairsReluctance", (Number)this.stairsReluctance, WalkPreferences.DEFAULT.stairsReluctance).addNum("stairsTimeFactor", (Number)this.stairsTimeFactor, WalkPreferences.DEFAULT.stairsTimeFactor).addNum("safetyFactor", (Number)this.safetyFactor, WalkPreferences.DEFAULT.safetyFactor).toString();
    }

    public static class Builder {
        private final WalkPreferences original;
        private double speed;
        private double reluctance;
        private int boardCost;
        private double stairsReluctance;
        private double stairsTimeFactor;
        private double safetyFactor;

        public Builder(WalkPreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.boardCost = original.boardCost;
            this.stairsReluctance = original.stairsReluctance;
            this.stairsTimeFactor = original.stairsTimeFactor;
            this.safetyFactor = original.safetyFactor;
        }

        public WalkPreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public int boardCost() {
            return this.boardCost;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = boardCost;
            return this;
        }

        public double stairsReluctance() {
            return this.stairsReluctance;
        }

        public Builder withStairsReluctance(double stairsReluctance) {
            this.stairsReluctance = stairsReluctance;
            return this;
        }

        public double stairsTimeFactor() {
            return this.stairsTimeFactor;
        }

        public Builder withStairsTimeFactor(double stairsTimeFactor) {
            this.stairsTimeFactor = stairsTimeFactor;
            return this;
        }

        public double safetyFactor() {
            return this.safetyFactor;
        }

        public Builder withSafetyFactor(double safetyFactor) {
            this.safetyFactor = safetyFactor < 0.0 ? 0.0 : (safetyFactor > 1.0 ? 1.0 : safetyFactor);
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public WalkPreferences build() {
            WalkPreferences newObj = new WalkPreferences(this);
            return this.original.equals(newObj) ? this.original : newObj;
        }
    }
}

