/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterPreferences;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.api.request.preference.SystemPreferences;
import org.opentripplanner.routing.api.request.preference.TransferPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.util.lang.ObjectUtils;

public final class RoutingPreferences
implements Serializable {
    private static final RoutingPreferences DEFAULT = new RoutingPreferences();
    private final TransitPreferences transit;
    private final TransferPreferences transfer;
    private final WalkPreferences walk;
    private final StreetPreferences street;
    private final WheelchairPreferences wheelchair;
    private final BikePreferences bike;
    private final CarPreferences car;
    private final VehicleRentalPreferences rental;
    private final VehicleParkingPreferences parking;
    private final SystemPreferences system;
    private final ItineraryFilterPreferences itineraryFilter;

    public RoutingPreferences() {
        this.transit = TransitPreferences.DEFAULT;
        this.transfer = TransferPreferences.DEFAULT;
        this.walk = WalkPreferences.DEFAULT;
        this.street = StreetPreferences.DEFAULT;
        this.wheelchair = WheelchairPreferences.DEFAULT;
        this.bike = BikePreferences.DEFAULT;
        this.car = CarPreferences.DEFAULT;
        this.rental = VehicleRentalPreferences.DEFAULT;
        this.parking = VehicleParkingPreferences.DEFAULT;
        this.system = SystemPreferences.DEFAULT;
        this.itineraryFilter = ItineraryFilterPreferences.DEFAULT;
    }

    private RoutingPreferences(Builder builder) {
        this.transit = Objects.requireNonNull(builder.transit());
        this.transfer = Objects.requireNonNull(builder.transfer());
        this.walk = Objects.requireNonNull(builder.walk());
        this.wheelchair = Objects.requireNonNull(builder.wheelchair());
        this.street = Objects.requireNonNull(builder.street());
        this.bike = Objects.requireNonNull(builder.bike());
        this.car = Objects.requireNonNull(builder.car());
        this.rental = Objects.requireNonNull(builder.rental());
        this.parking = Objects.requireNonNull(builder.parking());
        this.system = Objects.requireNonNull(builder.system());
        this.itineraryFilter = Objects.requireNonNull(builder.itineraryFilter());
    }

    public Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public TransitPreferences transit() {
        return this.transit;
    }

    public TransferPreferences transfer() {
        return this.transfer;
    }

    public WalkPreferences walk() {
        return this.walk;
    }

    public StreetPreferences street() {
        return this.street;
    }

    @Nonnull
    public WheelchairPreferences wheelchair() {
        return this.wheelchair;
    }

    public BikePreferences bike() {
        return this.bike;
    }

    public CarPreferences car() {
        return this.car;
    }

    public VehicleRentalPreferences rental() {
        return this.rental;
    }

    public VehicleParkingPreferences parking() {
        return this.parking;
    }

    @Nonnull
    public ItineraryFilterPreferences itineraryFilter() {
        return this.itineraryFilter;
    }

    public SystemPreferences system() {
        return this.system;
    }

    public double getSpeed(TraverseMode mode, boolean walkingBike) {
        return switch (mode) {
            case TraverseMode.WALK -> {
                if (walkingBike) {
                    yield this.bike.walkingSpeed();
                }
                yield this.walk.speed();
            }
            case TraverseMode.BICYCLE -> this.bike.speed();
            case TraverseMode.CAR -> this.car.speed();
            default -> throw new IllegalArgumentException("getSpeed(): Invalid mode " + mode);
        };
    }

    public static class Builder {
        private final RoutingPreferences original;
        private TransitPreferences transit = null;
        private TransferPreferences transfer = null;
        private WalkPreferences walk = null;
        private StreetPreferences street = null;
        private WheelchairPreferences wheelchair = null;
        private BikePreferences bike = null;
        private CarPreferences car = null;
        private VehicleRentalPreferences rental = null;
        private VehicleParkingPreferences parking = null;
        private SystemPreferences system = null;
        private ItineraryFilterPreferences itineraryFilter = null;

        public Builder(RoutingPreferences original) {
            this.original = original;
        }

        public RoutingPreferences original() {
            return this.original;
        }

        public TransitPreferences transit() {
            return this.transit == null ? this.original.transit : this.transit;
        }

        public Builder withTransit(Consumer<TransitPreferences.Builder> body) {
            this.transit = ObjectUtils.ifNotNull(this.transit, this.original.transit).copyOf().apply(body).build();
            return this;
        }

        public TransferPreferences transfer() {
            return this.transfer == null ? this.original.transfer : this.transfer;
        }

        public Builder withTransfer(Consumer<TransferPreferences.Builder> body) {
            this.transfer = ObjectUtils.ifNotNull(this.transfer, this.original.transfer).copyOf().apply(body).build();
            return this;
        }

        public WalkPreferences walk() {
            return this.walk == null ? this.original.walk() : this.walk;
        }

        public Builder withWalk(Consumer<WalkPreferences.Builder> body) {
            this.walk = ObjectUtils.ifNotNull(this.walk, this.original.walk).copyOf().apply(body).build();
            return this;
        }

        public StreetPreferences street() {
            return this.street == null ? this.original.street : this.street;
        }

        public Builder withStreet(Consumer<StreetPreferences.Builder> body) {
            this.street = ObjectUtils.ifNotNull(this.street, this.original.street).copyOf().apply(body).build();
            return this;
        }

        public WheelchairPreferences wheelchair() {
            return this.wheelchair == null ? this.original.wheelchair : this.wheelchair;
        }

        public Builder withWheelchair(WheelchairPreferences wheelchair) {
            this.wheelchair = wheelchair;
            return this;
        }

        public BikePreferences bike() {
            return this.bike == null ? this.original.bike : this.bike;
        }

        public Builder withBike(Consumer<BikePreferences.Builder> body) {
            this.bike = ObjectUtils.ifNotNull(this.bike, this.original.bike).copyOf().apply(body).build();
            return this;
        }

        public CarPreferences car() {
            return this.car == null ? this.original.car : this.car;
        }

        public Builder withCar(Consumer<CarPreferences.Builder> body) {
            this.car = ObjectUtils.ifNotNull(this.car, this.original.car).copyOf().apply(body).build();
            return this;
        }

        public VehicleRentalPreferences rental() {
            return this.rental == null ? this.original.rental : this.rental;
        }

        public Builder withRental(Consumer<VehicleRentalPreferences.Builder> body) {
            this.rental = ObjectUtils.ifNotNull(this.rental, this.original.rental).copyOf().apply(body).build();
            return this;
        }

        public VehicleParkingPreferences parking() {
            return this.parking == null ? this.original.parking : this.parking;
        }

        public Builder withParking(VehicleParkingPreferences parking) {
            this.parking = parking;
            return this;
        }

        public SystemPreferences system() {
            return this.system == null ? this.original.system : this.system;
        }

        public Builder withSystem(Consumer<SystemPreferences.Builder> body) {
            this.system = ObjectUtils.ifNotNull(this.system, this.original.system).copyOf().apply(body).build();
            return this;
        }

        public ItineraryFilterPreferences itineraryFilter() {
            return this.itineraryFilter == null ? this.original.itineraryFilter : this.itineraryFilter;
        }

        public Builder withItineraryFilter(Consumer<ItineraryFilterPreferences.Builder> body) {
            this.itineraryFilter = ObjectUtils.ifNotNull(this.itineraryFilter, this.original.itineraryFilter).copyOf().apply(body).build();
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public RoutingPreferences build() {
            RoutingPreferences value = new RoutingPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

