/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.routing.api.request.framework.RequestFunctions;
import org.opentripplanner.routing.api.request.framework.Units;

public final class ItineraryFilterPreferences {
    public static final ItineraryFilterPreferences DEFAULT = new ItineraryFilterPreferences();
    private final boolean debug;
    private final double groupSimilarityKeepOne;
    private final double groupSimilarityKeepThree;
    private final double groupedOtherThanSameLegsMaxCostMultiplier;
    private final TransitGeneralizedCostFilterParams transitGeneralizedCostLimit;
    private final double bikeRentalDistanceRatio;
    private final double parkAndRideDurationRatio;
    private final DoubleAlgorithmFunction nonTransitGeneralizedCostLimit;
    private final boolean filterItinerariesWithSameFirstOrLastTrip;
    private final boolean accessibilityScore;
    private final boolean removeItinerariesWithSameRoutesAndStops;

    private ItineraryFilterPreferences() {
        this.debug = false;
        this.groupSimilarityKeepOne = 0.85;
        this.groupSimilarityKeepThree = 0.68;
        this.groupedOtherThanSameLegsMaxCostMultiplier = 2.0;
        this.bikeRentalDistanceRatio = 0.0;
        this.parkAndRideDurationRatio = 0.0;
        this.transitGeneralizedCostLimit = new TransitGeneralizedCostFilterParams(RequestFunctions.createLinearFunction(900.0, 1.5), 0.4);
        this.nonTransitGeneralizedCostLimit = RequestFunctions.createLinearFunction(3600.0, 2.0);
        this.filterItinerariesWithSameFirstOrLastTrip = false;
        this.accessibilityScore = false;
        this.removeItinerariesWithSameRoutesAndStops = false;
    }

    private ItineraryFilterPreferences(Builder builder) {
        this.debug = builder.debug;
        this.groupSimilarityKeepOne = Units.reluctance(builder.groupSimilarityKeepOne);
        this.groupSimilarityKeepThree = Units.reluctance(builder.groupSimilarityKeepThree);
        this.groupedOtherThanSameLegsMaxCostMultiplier = Units.reluctance(builder.groupedOtherThanSameLegsMaxCostMultiplier);
        this.transitGeneralizedCostLimit = Objects.requireNonNull(builder.transitGeneralizedCostLimit);
        this.nonTransitGeneralizedCostLimit = Objects.requireNonNull(builder.nonTransitGeneralizedCostLimit);
        this.bikeRentalDistanceRatio = Units.ratio(builder.bikeRentalDistanceRatio);
        this.parkAndRideDurationRatio = Units.ratio(builder.parkAndRideDurationRatio);
        this.filterItinerariesWithSameFirstOrLastTrip = builder.filterItinerariesWithSameFirstOrLastTrip;
        this.accessibilityScore = builder.accessibilityScore;
        this.removeItinerariesWithSameRoutesAndStops = builder.removeItinerariesWithSameRoutesAndStops;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public boolean debug() {
        return this.debug;
    }

    public double groupSimilarityKeepOne() {
        return this.groupSimilarityKeepOne;
    }

    public double groupSimilarityKeepThree() {
        return this.groupSimilarityKeepThree;
    }

    public double groupedOtherThanSameLegsMaxCostMultiplier() {
        return this.groupedOtherThanSameLegsMaxCostMultiplier;
    }

    public TransitGeneralizedCostFilterParams transitGeneralizedCostLimit() {
        return this.transitGeneralizedCostLimit;
    }

    public double bikeRentalDistanceRatio() {
        return this.bikeRentalDistanceRatio;
    }

    public double parkAndRideDurationRatio() {
        return this.parkAndRideDurationRatio;
    }

    public DoubleAlgorithmFunction nonTransitGeneralizedCostLimit() {
        return this.nonTransitGeneralizedCostLimit;
    }

    public boolean filterItinerariesWithSameFirstOrLastTrip() {
        return this.filterItinerariesWithSameFirstOrLastTrip;
    }

    public boolean removeItinerariesWithSameRoutesAndStops() {
        return this.removeItinerariesWithSameRoutesAndStops;
    }

    public boolean useAccessibilityScore() {
        return this.accessibilityScore;
    }

    public static class Builder {
        private final ItineraryFilterPreferences original;
        private boolean debug;
        private double groupSimilarityKeepOne;
        private double groupSimilarityKeepThree;
        private double groupedOtherThanSameLegsMaxCostMultiplier;
        private TransitGeneralizedCostFilterParams transitGeneralizedCostLimit;
        private double bikeRentalDistanceRatio;
        private double parkAndRideDurationRatio;
        private DoubleAlgorithmFunction nonTransitGeneralizedCostLimit;
        private boolean filterItinerariesWithSameFirstOrLastTrip;
        private boolean removeItinerariesWithSameRoutesAndStops;
        private boolean accessibilityScore;

        public ItineraryFilterPreferences original() {
            return this.original;
        }

        public Builder withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder withGroupSimilarityKeepOne(double groupSimilarityKeepOne) {
            this.groupSimilarityKeepOne = groupSimilarityKeepOne;
            return this;
        }

        public Builder withGroupSimilarityKeepThree(double groupSimilarityKeepThree) {
            this.groupSimilarityKeepThree = groupSimilarityKeepThree;
            return this;
        }

        public Builder withGroupedOtherThanSameLegsMaxCostMultiplier(double groupedOtherThanSameLegsMaxCostMultiplier) {
            this.groupedOtherThanSameLegsMaxCostMultiplier = groupedOtherThanSameLegsMaxCostMultiplier;
            return this;
        }

        public Builder withTransitGeneralizedCostLimit(TransitGeneralizedCostFilterParams transitGeneralizedCostLimit) {
            this.transitGeneralizedCostLimit = transitGeneralizedCostLimit;
            return this;
        }

        public Builder withBikeRentalDistanceRatio(double bikeRentalDistanceRatio) {
            this.bikeRentalDistanceRatio = bikeRentalDistanceRatio;
            return this;
        }

        public Builder withParkAndRideDurationRatio(double parkAndRideDurationRatio) {
            this.parkAndRideDurationRatio = parkAndRideDurationRatio;
            return this;
        }

        public Builder withNonTransitGeneralizedCostLimit(DoubleAlgorithmFunction nonTransitGeneralizedCostLimit) {
            this.nonTransitGeneralizedCostLimit = nonTransitGeneralizedCostLimit;
            return this;
        }

        public Builder withFilterItinerariesWithSameFirstOrLastTrip(boolean filterItinerariesWithSameFirstOrLastTrip) {
            this.filterItinerariesWithSameFirstOrLastTrip = filterItinerariesWithSameFirstOrLastTrip;
            return this;
        }

        public Builder withRemoveItinerariesWithSameRoutesAndStops(boolean removeItinerariesWithSameRoutesAndStops) {
            this.removeItinerariesWithSameRoutesAndStops = removeItinerariesWithSameRoutesAndStops;
            return this;
        }

        public Builder withAccessibilityScore(boolean accessibilityScore) {
            this.accessibilityScore = accessibilityScore;
            return this;
        }

        public Builder(ItineraryFilterPreferences original) {
            this.original = original;
            this.debug = original.debug;
            this.groupSimilarityKeepOne = original.groupSimilarityKeepOne;
            this.groupSimilarityKeepThree = original.groupSimilarityKeepThree;
            this.groupedOtherThanSameLegsMaxCostMultiplier = original.groupedOtherThanSameLegsMaxCostMultiplier;
            this.transitGeneralizedCostLimit = original.transitGeneralizedCostLimit;
            this.nonTransitGeneralizedCostLimit = original.nonTransitGeneralizedCostLimit;
            this.bikeRentalDistanceRatio = original.bikeRentalDistanceRatio;
            this.parkAndRideDurationRatio = original.parkAndRideDurationRatio;
            this.filterItinerariesWithSameFirstOrLastTrip = original.filterItinerariesWithSameFirstOrLastTrip;
            this.removeItinerariesWithSameRoutesAndStops = original.removeItinerariesWithSameRoutesAndStops;
            this.accessibilityScore = original.accessibilityScore;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public ItineraryFilterPreferences build() {
            ItineraryFilterPreferences value = new ItineraryFilterPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

