/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class ElevatorPreferences
implements Serializable {
    public static final ElevatorPreferences DEFAULT = new ElevatorPreferences();
    private final int boardCost;
    private final int boardTime;
    private final int hopCost;
    private final int hopTime;

    private ElevatorPreferences() {
        this.boardCost = 90;
        this.boardTime = 90;
        this.hopCost = 20;
        this.hopTime = 20;
    }

    private ElevatorPreferences(Builder builder) {
        this.boardCost = Units.cost(builder.boardCost);
        this.boardTime = Units.duration(builder.boardTime);
        this.hopCost = Units.cost(builder.hopCost);
        this.hopTime = Units.duration(builder.hopTime);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int boardCost() {
        return this.boardCost;
    }

    public int boardTime() {
        return this.boardTime;
    }

    public int hopCost() {
        return this.hopCost;
    }

    public int hopTime() {
        return this.hopTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElevatorPreferences that = (ElevatorPreferences)o;
        return this.boardCost == that.boardCost && this.boardTime == that.boardTime && this.hopTime == that.hopTime && this.hopCost == that.hopCost;
    }

    public int hashCode() {
        return Objects.hash(this.boardCost, this.boardTime, this.hopTime, this.hopCost);
    }

    public String toString() {
        return ToStringBuilder.of(ElevatorPreferences.class).addCost("boardCost", this.boardCost, ElevatorPreferences.DEFAULT.boardCost).addDurationSec("boardTime", this.boardTime, ElevatorPreferences.DEFAULT.boardTime).addCost("hopCost", this.hopCost, ElevatorPreferences.DEFAULT.hopCost).addDurationSec("hopTime", this.hopTime, ElevatorPreferences.DEFAULT.hopTime).toString();
    }

    public static class Builder {
        private final ElevatorPreferences original;
        private int boardCost;
        private int boardTime;
        private int hopTime;
        private int hopCost;

        public Builder(ElevatorPreferences original) {
            this.original = original;
            this.boardCost = original.boardCost;
            this.boardTime = original.boardTime;
            this.hopCost = original.hopCost;
            this.hopTime = original.hopTime;
        }

        public ElevatorPreferences original() {
            return this.original;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = boardCost;
            return this;
        }

        public Builder withBoardTime(int boardTime) {
            this.boardTime = boardTime;
            return this;
        }

        public Builder withHopTime(int hopTime) {
            this.hopTime = hopTime;
            return this;
        }

        public Builder withHopCost(int hopCost) {
            this.hopCost = hopCost;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        ElevatorPreferences build() {
            ElevatorPreferences value = new ElevatorPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

