/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class BikePreferences
implements Serializable {
    public static final BikePreferences DEFAULT = new BikePreferences();
    private final double speed;
    private final double reluctance;
    private final int boardCost;
    private final double walkingSpeed;
    private final double walkingReluctance;
    private final int switchTime;
    private final int switchCost;
    private final int parkTime;
    private final int parkCost;
    private final BicycleOptimizeType optimizeType;
    private final TimeSlopeSafetyTriangle optimizeTriangle;

    private BikePreferences() {
        this.speed = 5.0;
        this.reluctance = 2.0;
        this.boardCost = 600;
        this.walkingSpeed = 1.33;
        this.walkingReluctance = 5.0;
        this.switchTime = 0;
        this.switchCost = 0;
        this.parkTime = 60;
        this.parkCost = 120;
        this.optimizeType = BicycleOptimizeType.SAFE;
        this.optimizeTriangle = TimeSlopeSafetyTriangle.DEFAULT;
    }

    private BikePreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.boardCost = Units.cost(builder.boardCost);
        this.walkingSpeed = Units.speed(builder.walkingSpeed);
        this.walkingReluctance = Units.reluctance(builder.walkingReluctance);
        this.switchTime = Units.duration(builder.switchTime);
        this.switchCost = Units.cost(builder.switchCost);
        this.parkTime = Units.duration(builder.parkTime);
        this.parkCost = Units.cost(builder.parkCost);
        this.optimizeType = Objects.requireNonNull(builder.optimizeType);
        this.optimizeTriangle = Objects.requireNonNull(builder.optimizeTriangle);
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int boardCost() {
        return this.boardCost;
    }

    public double walkingSpeed() {
        return this.walkingSpeed;
    }

    public double walkingReluctance() {
        return this.walkingReluctance;
    }

    public int switchTime() {
        return this.switchTime;
    }

    public int switchCost() {
        return this.switchCost;
    }

    public int parkTime() {
        return this.parkTime;
    }

    public int parkCost() {
        return this.parkCost;
    }

    public BicycleOptimizeType optimizeType() {
        return this.optimizeType;
    }

    public TimeSlopeSafetyTriangle optimizeTriangle() {
        return this.optimizeTriangle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BikePreferences that = (BikePreferences)o;
        return DoubleUtils.doubleEquals(that.speed, this.speed) && DoubleUtils.doubleEquals(that.reluctance, this.reluctance) && this.boardCost == that.boardCost && DoubleUtils.doubleEquals(that.walkingSpeed, this.walkingSpeed) && DoubleUtils.doubleEquals(that.walkingReluctance, this.walkingReluctance) && this.switchTime == that.switchTime && this.switchCost == that.switchCost && this.parkTime == that.parkTime && this.parkCost == that.parkCost && this.optimizeType == that.optimizeType && this.optimizeTriangle.equals(that.optimizeTriangle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.speed, this.reluctance, this.boardCost, this.walkingSpeed, this.walkingReluctance, this.switchTime, this.switchCost, this.parkTime, this.parkCost, this.optimizeType, this.optimizeTriangle});
    }

    public String toString() {
        return ToStringBuilder.of(BikePreferences.class).addNum("speed", (Number)this.speed, BikePreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, BikePreferences.DEFAULT.reluctance).addNum("boardCost", (Number)this.boardCost, BikePreferences.DEFAULT.boardCost).addNum("walkingSpeed", (Number)this.walkingSpeed, BikePreferences.DEFAULT.walkingSpeed).addNum("walkingReluctance", (Number)this.walkingReluctance, BikePreferences.DEFAULT.walkingReluctance).addDurationSec("switchTime", this.switchTime, BikePreferences.DEFAULT.switchTime).addNum("switchCost", (Number)this.switchCost, BikePreferences.DEFAULT.switchCost).addDurationSec("parkTime", this.parkTime, BikePreferences.DEFAULT.parkTime).addNum("parkCost", (Number)this.parkCost, BikePreferences.DEFAULT.parkCost).addEnum("optimizeType", this.optimizeType, BikePreferences.DEFAULT.optimizeType).addObj("optimizeTriangle", this.optimizeTriangle, BikePreferences.DEFAULT.optimizeTriangle).toString();
    }

    public static class Builder {
        private final BikePreferences original;
        private double speed;
        private double reluctance;
        private int boardCost;
        private double walkingSpeed;
        private double walkingReluctance;
        private int switchTime;
        private int switchCost;
        private int parkTime;
        private int parkCost;
        private BicycleOptimizeType optimizeType;
        private TimeSlopeSafetyTriangle optimizeTriangle;

        public Builder(BikePreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.boardCost = original.boardCost;
            this.walkingSpeed = original.walkingSpeed;
            this.walkingReluctance = original.walkingReluctance;
            this.switchTime = original.switchTime;
            this.switchCost = original.switchCost;
            this.parkTime = original.parkTime;
            this.parkCost = original.parkCost;
            this.optimizeType = original.optimizeType;
            this.optimizeTriangle = original.optimizeTriangle;
        }

        public BikePreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public int boardCost() {
            return this.boardCost;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = boardCost;
            return this;
        }

        public double walkingSpeed() {
            return this.walkingSpeed;
        }

        public Builder withWalkingSpeed(double walkingSpeed) {
            this.walkingSpeed = walkingSpeed;
            return this;
        }

        public double walkingReluctance() {
            return this.walkingReluctance;
        }

        public Builder withWalkingReluctance(double walkingReluctance) {
            this.walkingReluctance = walkingReluctance;
            return this;
        }

        public int switchTime() {
            return this.switchTime;
        }

        public Builder withSwitchTime(int switchTime) {
            this.switchTime = switchTime;
            return this;
        }

        public int switchCost() {
            return this.switchCost;
        }

        public Builder withSwitchCost(int switchCost) {
            this.switchCost = switchCost;
            return this;
        }

        public int parkTime() {
            return this.parkTime;
        }

        public Builder withParkTime(int parkTime) {
            this.parkTime = parkTime;
            return this;
        }

        public int parkCost() {
            return this.parkCost;
        }

        public Builder withParkCost(int parkCost) {
            this.parkCost = parkCost;
            return this;
        }

        public BicycleOptimizeType optimizeType() {
            return this.optimizeType;
        }

        public Builder withOptimizeType(BicycleOptimizeType optimizeType) {
            this.optimizeType = optimizeType;
            return this;
        }

        public TimeSlopeSafetyTriangle optimizeTriangle() {
            return this.optimizeTriangle;
        }

        public Builder withOptimizeTriangle(Consumer<TimeSlopeSafetyTriangle.Builder> body) {
            TimeSlopeSafetyTriangle.Builder builder = TimeSlopeSafetyTriangle.of();
            body.accept(builder);
            this.optimizeTriangle = builder.buildOrDefault(this.optimizeTriangle);
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public BikePreferences build() {
            BikePreferences value = new BikePreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

