/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class AccessibilityPreferences {
    private static final int NOT_SET = 9999999;
    private static final AccessibilityPreferences ONLY_CONSIDER_ACCESSIBLE = new AccessibilityPreferences(true, 9999999, 9999999);
    private final boolean onlyConsiderAccessible;
    private final int unknownCost;
    private final int inaccessibleCost;

    private AccessibilityPreferences(boolean onlyConsiderAccessible, int unknownCost, int inaccessibleCost) {
        this.onlyConsiderAccessible = onlyConsiderAccessible;
        this.unknownCost = Units.cost(unknownCost);
        this.inaccessibleCost = Units.cost(inaccessibleCost);
    }

    public static AccessibilityPreferences ofOnlyAccessible() {
        return ONLY_CONSIDER_ACCESSIBLE;
    }

    public static AccessibilityPreferences ofCost(int unknownCost, int inaccessibleCost) {
        return new AccessibilityPreferences(false, unknownCost, inaccessibleCost);
    }

    public boolean onlyConsiderAccessible() {
        return this.onlyConsiderAccessible;
    }

    public int unknownCost() {
        return this.unknownCost;
    }

    public int inaccessibleCost() {
        return this.inaccessibleCost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessibilityPreferences that = (AccessibilityPreferences)o;
        return this.onlyConsiderAccessible == that.onlyConsiderAccessible && this.unknownCost == that.unknownCost && this.inaccessibleCost == that.inaccessibleCost;
    }

    public int hashCode() {
        return Objects.hash(this.onlyConsiderAccessible, this.unknownCost, this.inaccessibleCost);
    }

    public String toString() {
        if (this.onlyConsiderAccessible) {
            return "OnlyConsiderAccessible";
        }
        return ToStringBuilder.of(AccessibilityPreferences.class).addCost("unknownCost", this.unknownCost, 9999999).addCost("inaccessibleCost", this.inaccessibleCost, 9999999).toString();
    }
}

