/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.api.request.RequestModesBuilder;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.util.lang.ToStringBuilder;

public class RequestModes {
    private static final RequestModes DEFAULTS = new RequestModes(StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, MainAndSubMode.all());
    @Nonnull
    public final StreetMode accessMode;
    @Nonnull
    public final StreetMode egressMode;
    @Nonnull
    public final StreetMode directMode;
    @Nonnull
    public final StreetMode transferMode;
    @Nonnull
    public final List<MainAndSubMode> transitModes;

    private RequestModes(StreetMode accessMode, StreetMode egressMode, StreetMode directMode, StreetMode transferMode, Collection<MainAndSubMode> transitModes) {
        this.accessMode = accessMode != null && accessMode.access ? accessMode : StreetMode.NOT_SET;
        this.egressMode = egressMode != null && egressMode.egress ? egressMode : StreetMode.NOT_SET;
        this.directMode = directMode != null ? directMode : StreetMode.NOT_SET;
        this.transferMode = transferMode != null && transferMode.transfer ? transferMode : StreetMode.NOT_SET;
        this.transitModes = transitModes == null ? MainAndSubMode.all() : List.copyOf(transitModes);
    }

    public RequestModes(RequestModesBuilder builder) {
        this(builder.accessMode(), builder.egressMode(), builder.directMode(), builder.transferMode(), builder.transitModes());
    }

    public static RequestModesBuilder of() {
        return DEFAULTS.copyOf();
    }

    public RequestModesBuilder copyOf() {
        return new RequestModesBuilder(this);
    }

    public static RequestModes defaultRequestModes() {
        return DEFAULTS;
    }

    public boolean contains(StreetMode streetMode) {
        return streetMode.equals((Object)this.accessMode) || streetMode.equals((Object)this.egressMode) || streetMode.equals((Object)this.directMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestModes that = (RequestModes)o;
        if (this.accessMode != that.accessMode) {
            return false;
        }
        if (this.egressMode != that.egressMode) {
            return false;
        }
        if (this.directMode != that.directMode) {
            return false;
        }
        if (this.transferMode != that.transferMode) {
            return false;
        }
        return this.transitModes.equals(that.transitModes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessMode, this.egressMode, this.directMode, this.transferMode, this.transitModes});
    }

    public String toString() {
        return ToStringBuilder.of(RequestModes.class).addEnum("accessMode", this.accessMode).addEnum("egressMode", this.egressMode).addEnum("directMode", this.directMode).addEnum("transferMode", this.transferMode).addCol("transitModes", this.transitModes).toString();
    }
}

