/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.algorithm.transferoptimization.model.StopTime;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripStopTime;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripToTripTransfer;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferServiceAdaptor;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;

public class TransferGenerator<T extends RaptorTripSchedule> {
    private static final int SAME_STOP_TRANSFER_TIME = 0;
    private final TransferServiceAdaptor<T> transferServiceAdaptor;
    private final RaptorSlackProvider slackProvider;
    private final RaptorTransitDataProvider<T> stdTransfers;
    private T fromTrip;
    private T toTrip;

    public TransferGenerator(TransferServiceAdaptor<T> transferServiceAdaptor, RaptorSlackProvider slackProvider, RaptorTransitDataProvider<T> stdTransfers) {
        this.transferServiceAdaptor = transferServiceAdaptor;
        this.slackProvider = slackProvider;
        this.stdTransfers = stdTransfers;
    }

    public List<List<TripToTripTransfer<T>>> findAllPossibleTransfers(List<TransitPathLeg<T>> transitLegs) {
        ArrayList<List<TripToTripTransfer<T>>> result = new ArrayList<List<TripToTripTransfer<T>>>();
        TransitPathLeg<T> fromLeg = transitLegs.get(0);
        TripStopTime<T> earliestDeparture = this.getFromStopTime(fromLeg);
        for (int i = 1; i < transitLegs.size(); ++i) {
            TransitPathLeg<T> toLeg = transitLegs.get(i);
            List<TripToTripTransfer<T>> transfers = this.findTransfers(fromLeg.trip(), earliestDeparture, toLeg.trip());
            result.add(transfers);
            earliestDeparture = this.findMinimumToStopTime(transfers);
            fromLeg = toLeg;
        }
        this.removeTransfersAfterLatestStopArrival(TransferGenerator.last(transitLegs).getToStopPosition(), result);
        return result;
    }

    private static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    private List<TripToTripTransfer<T>> findTransfers(T fromTrip, StopTime fromTripDeparture, T toTrip) {
        this.fromTrip = fromTrip;
        this.toTrip = toTrip;
        int firstStopPos = this.firstPossibleArrivalStopPos(fromTrip, fromTripDeparture);
        return this.findAllTransfers(firstStopPos);
    }

    private int firstPossibleArrivalStopPos(T trip, StopTime departure) {
        return 1 + trip.findDepartureStopPosition(departure.time(), departure.stop());
    }

    private List<TripToTripTransfer<T>> findAllTransfers(int stopPos) {
        ArrayList<TripToTripTransfer<T>> result = new ArrayList<TripToTripTransfer<T>>();
        while (stopPos < this.fromTrip.pattern().numberOfStopsInPattern()) {
            boolean alightingPossible = this.fromTrip.pattern().alightingPossibleAt(stopPos);
            if (alightingPossible) {
                TripStopTime<T> from = TripStopTime.arrival(this.fromTrip, stopPos);
                result.addAll(this.transferFromSameStop(from));
                result.addAll(this.findStandardTransfers(from));
            }
            ++stopPos;
        }
        return result;
    }

    private Collection<TripToTripTransfer<T>> transferFromSameStop(TripStopTime<T> from) {
        ArrayList<TripToTripTransfer<T>> result = new ArrayList<TripToTripTransfer<T>>();
        int stop = from.stop();
        List<Integer> possibleTransfers = this.toTrip.findDepartureStopPositions(from.time(), stop);
        for (Integer stopPos : possibleTransfers) {
            int earliestBoardTime;
            ConstrainedTransfer tx = this.transferServiceAdaptor.findTransfer(from, this.toTrip, stop, stopPos);
            if (!this.isAllowedTransfer(stopPos, tx) || (earliestBoardTime = this.calculateEarliestBoardTime(from, tx, 0)) > this.toTrip.departure(stopPos)) continue;
            result.add(new TripToTripTransfer<T>(from, TripStopTime.departure(this.toTrip, stopPos), null, tx));
        }
        return result;
    }

    private Collection<? extends TripToTripTransfer<T>> findStandardTransfers(TripStopTime<T> from) {
        ArrayList<TripToTripTransfer<T>> result = new ArrayList<TripToTripTransfer<T>>();
        Iterator<RaptorTransfer> transfers = this.stdTransfers.getTransfersFromStop(from.stop());
        while (transfers.hasNext()) {
            RaptorTransfer it = transfers.next();
            int toStop = it.stop();
            List<Integer> possibleTransfers = this.toTrip.findDepartureStopPositions(from.time(), toStop);
            for (Integer stopPos : possibleTransfers) {
                int earliestBoardTime;
                ConstrainedTransfer tx = this.transferServiceAdaptor.findTransfer(from, this.toTrip, toStop, stopPos);
                if (!this.isAllowedTransfer(stopPos, tx) || (earliestBoardTime = this.calculateEarliestBoardTime(from, tx, it.durationInSeconds())) > this.toTrip.departure(stopPos)) continue;
                TripStopTime<T> to = TripStopTime.departure(this.toTrip, stopPos);
                result.add(new TripToTripTransfer<T>(from, to, it, tx));
            }
        }
        return result;
    }

    private int calculateEarliestBoardTime(TripStopTime<T> from, @Nullable ConstrainedTransfer tx, int regularTransferDurationInSec) {
        if (tx == null) {
            return this.calcRegularTransferEarliestBoardTime(from, regularTransferDurationInSec);
        }
        return tx.getTransferConstraint().calculateTransferTargetTime(from.time(), this.slackProvider.transferSlack(), () -> this.calcRegularTransferEarliestBoardTime(from, regularTransferDurationInSec), SearchDirection.FORWARD);
    }

    private int calcRegularTransferEarliestBoardTime(TripStopTime<T> from, int transferDurationInSeconds) {
        int transferDuration = this.slackProvider.calcRegularTransferDuration(transferDurationInSeconds, this.fromTrip.pattern().slackIndex(), this.toTrip.pattern().slackIndex());
        return from.time() + transferDuration;
    }

    @Nonnull
    private StopTime getFromStopTime(TransitPathLeg<T> leg) {
        return StopTime.stopTime(leg.fromStop(), leg.fromTime());
    }

    @Nonnull
    private TripStopTime<T> findMinimumToStopTime(List<TripToTripTransfer<T>> transfers) {
        return transfers.stream().map(TripToTripTransfer::to).min(Comparator.comparingInt(TripStopTime::time)).orElseThrow();
    }

    private void removeTransfersAfterLatestStopArrival(int latestArrivalStopPos, List<List<TripToTripTransfer<T>>> result) {
        int nextLatestArrivalStopPos = 0;
        for (int i = result.size() - 1; i >= 0; --i) {
            ArrayList<TripToTripTransfer<T>> filteredTransfers = new ArrayList<TripToTripTransfer<T>>();
            for (TripToTripTransfer<T> tx : result.get(i)) {
                if (tx.to().stopPosition() >= latestArrivalStopPos) continue;
                filteredTransfers.add(tx);
                nextLatestArrivalStopPos = Math.max(tx.from().stopPosition(), nextLatestArrivalStopPos);
            }
            latestArrivalStopPos = nextLatestArrivalStopPos;
            result.set(i, filteredTransfers);
        }
    }

    private boolean isAllowedTransfer(int stopPosition, ConstrainedTransfer tx) {
        if (!this.toTrip.pattern().boardingPossibleAt(stopPosition)) {
            return false;
        }
        if (tx == null) {
            return true;
        }
        return !tx.getTransferConstraint().isNotAllowed();
    }
}

