/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripStopTime;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.util.lang.ToStringBuilder;

public class TripToTripTransfer<T extends RaptorTripSchedule> {
    private final TripStopTime<T> from;
    private final TripStopTime<T> to;
    private final RaptorTransfer pathTransfer;
    private final ConstrainedTransfer constrainedTransfer;

    public TripToTripTransfer(TripStopTime<T> from, TripStopTime<T> to, RaptorTransfer pathTransfer, @Nullable ConstrainedTransfer constrainedTransfer) {
        this.from = from;
        this.to = to;
        this.pathTransfer = pathTransfer;
        this.constrainedTransfer = constrainedTransfer;
    }

    public TripStopTime<T> from() {
        return this.from;
    }

    public TripStopTime<T> to() {
        return this.to;
    }

    public int transferDuration() {
        return this.sameStop() ? 0 : this.pathTransfer.durationInSeconds();
    }

    public int generalizedCost() {
        return this.sameStop() ? 0 : this.pathTransfer.generalizedCost();
    }

    public boolean sameStop() {
        return this.from.stop() == this.to.stop();
    }

    @Nullable
    public RaptorTransfer getPathTransfer() {
        return this.pathTransfer;
    }

    @Nullable
    public ConstrainedTransfer constrainedTransfer() {
        return this.constrainedTransfer;
    }

    public String toString() {
        return ToStringBuilder.of(TripToTripTransfer.class).addObj("from", this.from).addObj("to", this.to).addObj("transfer", this.pathTransfer).toString();
    }
}

