/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.configure;

import java.util.function.IntFunction;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.transferoptimization.OptimizeTransferService;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinCostFilterChain;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinSafeTransferTimeCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TransferWaitTimeCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.services.OptimizePathDomainService;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferGenerator;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferOptimizedFilterFactory;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferServiceAdaptor;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public class TransferOptimizationServiceConfigurator<T extends RaptorTripSchedule> {
    private final IntFunction<StopLocation> stopLookup;
    private final RaptorStopNameResolver stopNameResolver;
    private final TransferService transferService;
    private final RaptorTransitDataProvider<T> transitDataProvider;
    private final int[] stopBoardAlightCosts;
    private final RaptorRequest<T> raptorRequest;
    private final TransferOptimizationParameters config;

    private TransferOptimizationServiceConfigurator(IntFunction<StopLocation> stopLookup, RaptorStopNameResolver stopNameResolver, TransferService transferService, RaptorTransitDataProvider<T> transitDataProvider, int[] stopBoardAlightCosts, RaptorRequest<T> raptorRequest, TransferOptimizationParameters config) {
        this.stopLookup = stopLookup;
        this.stopNameResolver = stopNameResolver;
        this.transferService = transferService;
        this.transitDataProvider = transitDataProvider;
        this.stopBoardAlightCosts = stopBoardAlightCosts;
        this.raptorRequest = raptorRequest;
        this.config = config;
    }

    public static <T extends RaptorTripSchedule> OptimizeTransferService<T> createOptimizeTransferService(IntFunction<StopLocation> stopLookup, RaptorStopNameResolver stopNameResolver, TransferService transferService, RaptorTransitDataProvider<T> transitDataProvider, int[] stopBoardAlightCosts, RaptorRequest<T> raptorRequest, TransferOptimizationParameters config) {
        return new TransferOptimizationServiceConfigurator<T>(stopLookup, stopNameResolver, transferService, transitDataProvider, stopBoardAlightCosts, raptorRequest, config).createOptimizeTransferService();
    }

    private OptimizeTransferService<T> createOptimizeTransferService() {
        TransferGenerator<T> pathTransferGenerator = this.createTransferGenerator(this.config.optimizeTransferPriority());
        MinCostFilterChain<OptimizedPathTail<T>> filter = this.createTransferOptimizedFilter(this.config.optimizeTransferPriority(), this.config.optimizeTransferWaitTime());
        if (this.config.optimizeTransferWaitTime()) {
            TransferWaitTimeCostCalculator transferWaitTimeCalculator = this.createTransferWaitTimeCalculator();
            OptimizePathDomainService<T> transfersPermutationService = this.createOptimizePathService(pathTransferGenerator, filter, transferWaitTimeCalculator, this.transitDataProvider.multiCriteriaCostCalculator());
            return new OptimizeTransferService<T>(transfersPermutationService, this.createMinSafeTxTimeService(), transferWaitTimeCalculator);
        }
        OptimizePathDomainService<T> transfersPermutationService = this.createOptimizePathService(pathTransferGenerator, filter, null, this.transitDataProvider.multiCriteriaCostCalculator());
        return new OptimizeTransferService<T>(transfersPermutationService);
    }

    private OptimizePathDomainService<T> createOptimizePathService(TransferGenerator<T> transferGenerator, MinCostFilterChain<OptimizedPathTail<T>> transferPointFilter, TransferWaitTimeCostCalculator transferWaitTimeCostCalculator, CostCalculator<T> costCalculator) {
        return new OptimizePathDomainService<T>(transferGenerator, costCalculator, this.raptorRequest.slackProvider(), transferWaitTimeCostCalculator, this.stopBoardAlightCosts, this.config.extraStopBoardAlightCostsFactor(), transferPointFilter, this.stopNameResolver);
    }

    private MinSafeTransferTimeCalculator<T> createMinSafeTxTimeService() {
        return new MinSafeTransferTimeCalculator(this.raptorRequest.slackProvider());
    }

    private TransferGenerator<T> createTransferGenerator(boolean transferPriority) {
        TransferServiceAdaptor transferServiceAdaptor = this.transferService != null && transferPriority ? TransferServiceAdaptor.create(this.stopLookup, this.transferService) : TransferServiceAdaptor.noop();
        return new TransferGenerator(transferServiceAdaptor, this.raptorRequest.slackProvider(), this.transitDataProvider);
    }

    private TransferWaitTimeCostCalculator createTransferWaitTimeCalculator() {
        return new TransferWaitTimeCostCalculator(this.config.backTravelWaitTimeFactor(), this.config.minSafeWaitTimeFactor());
    }

    private MinCostFilterChain<OptimizedPathTail<T>> createTransferOptimizedFilter(boolean transferPriority, boolean optimizeWaitTime) {
        return TransferOptimizedFilterFactory.filter(transferPriority, optimizeWaitTime);
    }
}

