/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class TripScheduleBoardSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T>,
RaptorTripScheduleBoardOrAlightEvent<T> {
    private final TripSearchTimetable<T> timetable;
    private final int nTrips;
    private final int binarySearchThreshold;
    private int earliestBoardTime;
    private int stopPositionInPattern;
    private IntUnaryOperator departureTimes;
    private T candidateTrip;
    private int candidateTripIndex = -1;

    TripScheduleBoardSearch(TripSearchTimetable<T> timetable, int binarySearchThreshold) {
        this.timetable = timetable;
        this.nTrips = timetable.numberOfTripSchedules();
        this.binarySearchThreshold = binarySearchThreshold;
    }

    @Override
    public T getTrip() {
        return this.candidateTrip;
    }

    @Override
    public int getTripIndex() {
        return this.candidateTripIndex;
    }

    @Override
    public int getTime() {
        return this.candidateTrip.departure(this.stopPositionInPattern);
    }

    @Override
    public int getStopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    public RaptorTransferConstraint getTransferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    @Override
    public RaptorTripScheduleBoardOrAlightEvent<T> search(int earliestTime, int stopPositionInPattern, int tripIndexUpperBound) {
        this.earliestBoardTime = earliestTime;
        this.stopPositionInPattern = stopPositionInPattern;
        this.departureTimes = this.timetable.getDepartureTimes(stopPositionInPattern);
        this.candidateTrip = null;
        this.candidateTripIndex = -1;
        if (tripIndexUpperBound == -1) {
            if (this.nTrips > this.binarySearchThreshold) {
                return this.findFirstBoardingOptimizedForLargeSetOfTrips();
            }
            return this.findBoardingBySteppingBackwardsInTime(this.nTrips);
        }
        return this.findBoardingBySteppingBackwardsInTime(tripIndexUpperBound);
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleBoardSearch.class).addObj("nTrips", this.nTrips).addObj("earliestBoardTime", this.earliestBoardTime).addObj("stopPos", this.stopPositionInPattern).addObj("tripIndex", this.candidateTripIndex).addObj("trip", this.candidateTrip).toString();
    }

    private RaptorTripScheduleBoardOrAlightEvent<T> findFirstBoardingOptimizedForLargeSetOfTrips() {
        int indexBestGuess = this.binarySearchForTripIndex();
        RaptorTripScheduleBoardOrAlightEvent<T> result = this.findBoardingBySteppingBackwardsInTime(indexBestGuess);
        if (result != null) {
            return this;
        }
        return this.findBoardingBySteppingForwardInTime(indexBestGuess);
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingBySteppingBackwardsInTime(int tripIndexUpperBound) {
        int i = tripIndexUpperBound - 1;
        while (i >= 0 && this.departureTimes.applyAsInt(i) >= this.earliestBoardTime) {
            this.candidateTripIndex = i--;
        }
        if (this.candidateTripIndex == -1) {
            return null;
        }
        this.candidateTrip = this.timetable.getTripSchedule(this.candidateTripIndex);
        return this;
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingBySteppingForwardInTime(int tripIndexLowerBound) {
        for (int i = tripIndexLowerBound; i < this.nTrips; ++i) {
            if (this.departureTimes.applyAsInt(i) < this.earliestBoardTime) continue;
            this.candidateTrip = this.timetable.getTripSchedule(i);
            this.candidateTripIndex = i;
            return this;
        }
        return null;
    }

    private int binarySearchForTripIndex() {
        int lower = 0;
        int upper = this.nTrips;
        while (upper - lower > this.binarySearchThreshold) {
            int m = (lower + upper) / 2;
            if (this.departureTimes.applyAsInt(m) >= this.earliestBoardTime) {
                upper = m;
                continue;
            }
            lower = m;
        }
        return upper == this.nTrips ? this.nTrips : upper + 1;
    }
}

