/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import gnu.trove.list.TIntList;
import java.util.BitSet;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.opentripplanner.routing.algorithm.raptoradapter.api.DefaultTripPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyAlightSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyBoardSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleSearchFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleWithOffset;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorRoute;
import org.opentripplanner.transit.raptor.api.transit.RaptorTimeTable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.transit.raptor.util.IntIterators;
import org.opentripplanner.util.lang.ToStringBuilder;

public class TripPatternForDates
implements RaptorRoute<TripSchedule>,
RaptorTimeTable<TripSchedule>,
DefaultTripPattern,
TripSearchTimetable<TripSchedule> {
    private final RoutingTripPattern tripPattern;
    private final TripPatternForDate[] tripPatternForDates;
    private final int[] offsets;
    private final int numberOfTripSchedules;
    private final boolean isFrequencyBased;
    private final int[] arrivalTimes;
    private final int[] departureTimes;
    private final Accessibility[] wheelchairBoardings;
    private final BitSet boardingPossible;
    private final BitSet alightingPossible;

    TripPatternForDates(RoutingTripPattern tripPattern, List<TripPatternForDate> tripPatternForDates, TIntList offsets, BitSet boardingPossible, BitSet alightningPossible) {
        this.tripPattern = tripPattern;
        this.tripPatternForDates = tripPatternForDates.toArray(new TripPatternForDate[0]);
        this.offsets = offsets.toArray();
        this.boardingPossible = boardingPossible;
        this.alightingPossible = alightningPossible;
        int numberOfTripSchedules = 0;
        boolean hasFrequencies = false;
        for (TripPatternForDate tripPatternForDate : this.tripPatternForDates) {
            numberOfTripSchedules += tripPatternForDate.numberOfTripSchedules();
            if (!tripPatternForDate.hasFrequencies()) continue;
            hasFrequencies = true;
        }
        this.numberOfTripSchedules = numberOfTripSchedules;
        this.isFrequencyBased = hasFrequencies;
        this.wheelchairBoardings = new Accessibility[numberOfTripSchedules];
        int nStops = tripPattern.numberOfStopsInPattern();
        this.arrivalTimes = new int[nStops * numberOfTripSchedules];
        this.departureTimes = new int[nStops * numberOfTripSchedules];
        int i = 0;
        for (int d = 0; d < this.tripPatternForDates.length; ++d) {
            int offset = this.offsets[d];
            for (TripTimes trip : this.tripPatternForDates[d].tripTimes()) {
                this.wheelchairBoardings[i] = trip.getWheelchairAccessibility();
                for (int s = 0; s < nStops; ++s) {
                    this.arrivalTimes[s * numberOfTripSchedules + i] = trip.getArrivalTime(s) + offset;
                    this.departureTimes[s * numberOfTripSchedules + i] = trip.getDepartureTime(s) + offset;
                }
                ++i;
            }
        }
    }

    public RoutingTripPattern getTripPattern() {
        return this.tripPattern;
    }

    public IntIterator tripPatternForDatesIndexIterator(boolean ascendingOnDate) {
        return ascendingOnDate ? IntIterators.intIncIterator(0, this.tripPatternForDates.length) : IntIterators.intDecIterator(this.tripPatternForDates.length, 0);
    }

    public TripPatternForDate tripPatternForDate(int index) {
        return this.tripPatternForDates[index];
    }

    @Deprecated
    public int tripPatternForDateOffsets(int index) {
        return this.offsets[index];
    }

    @Override
    public RaptorTimeTable<TripSchedule> timetable() {
        return this;
    }

    @Override
    public RaptorTripPattern pattern() {
        return this;
    }

    @Override
    public int patternIndex() {
        return this.tripPattern.patternIndex();
    }

    @Override
    public int numberOfStopsInPattern() {
        return this.tripPattern.numberOfStopsInPattern();
    }

    @Override
    public int stopIndex(int stopPositionInPattern) {
        return this.tripPattern.stopIndex(stopPositionInPattern);
    }

    @Override
    public boolean boardingPossibleAt(int stopPositionInPattern) {
        return this.boardingPossible.get(stopPositionInPattern);
    }

    @Override
    public boolean alightingPossibleAt(int stopPositionInPattern) {
        return this.alightingPossible.get(stopPositionInPattern);
    }

    @Override
    public int slackIndex() {
        return this.tripPattern.slackIndex();
    }

    public int transitReluctanceFactorIndex() {
        return this.tripPattern.transitReluctanceFactorIndex();
    }

    @Override
    public String debugInfo() {
        return this.tripPattern.debugInfo();
    }

    @Override
    public RaptorTripScheduleSearch<TripSchedule> tripSearch(SearchDirection direction) {
        if (this.useCustomizedTripSearch()) {
            return this.createCustomizedTripSearch(direction);
        }
        return TripScheduleSearchFactory.create(direction, this);
    }

    @Override
    public TripSchedule getTripSchedule(int index) {
        return new TripScheduleWithOffset(this, index);
    }

    @Override
    public IntUnaryOperator getArrivalTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return index -> this.arrivalTimes[base + index];
    }

    @Override
    public IntUnaryOperator getDepartureTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return index -> this.departureTimes[base + index];
    }

    public IntUnaryOperator getArrivalTimesForTrip(int index) {
        return stopPositionInPattern -> this.arrivalTimes[stopPositionInPattern * this.numberOfTripSchedules + index];
    }

    public IntUnaryOperator getDepartureTimesForTrip(int index) {
        return stopPositionInPattern -> this.departureTimes[stopPositionInPattern * this.numberOfTripSchedules + index];
    }

    @Override
    public int numberOfTripSchedules() {
        return this.numberOfTripSchedules;
    }

    @Override
    public Route route() {
        return this.tripPattern.route();
    }

    public boolean useCustomizedTripSearch() {
        return this.isFrequencyBased;
    }

    public RaptorTripScheduleSearch<TripSchedule> createCustomizedTripSearch(SearchDirection direction) {
        return direction.isForward() ? new TripFrequencyBoardSearch(this) : new TripFrequencyAlightSearch(this);
    }

    public String toString() {
        return ToStringBuilder.of(TripPatternForDates.class).addObj("pattern", this.debugInfo()).addServiceTimeSchedule("offsets", this.offsets).addNum("nTrips", this.numberOfTripSchedules).toString();
    }

    public Accessibility wheelchairBoardingForTrip(int index) {
        return this.wheelchairBoardings[index];
    }
}

