/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.routing.core.RouteMatcher;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;

public class RouteRequestTransitDataProviderFilter
implements TransitDataProviderFilter {
    private final boolean requireBikesAllowed;
    private final boolean wheelchairEnabled;
    private final WheelchairPreferences wheelchairPreferences;
    private final boolean includePlannedCancellations;
    private final AllowTransitModeFilter transitModeFilter;
    private final Set<FeedScopedId> bannedRoutes;
    private final Set<FeedScopedId> bannedTrips;

    public RouteRequestTransitDataProviderFilter(boolean requireBikesAllowed, boolean wheelchairEnabled, WheelchairPreferences wheelchairPreferences, boolean includePlannedCancellations, Collection<MainAndSubMode> allowedTransitModes, Collection<FeedScopedId> bannedRoutes, Collection<FeedScopedId> bannedTrips) {
        this.requireBikesAllowed = requireBikesAllowed;
        this.wheelchairEnabled = wheelchairEnabled;
        this.wheelchairPreferences = wheelchairPreferences;
        this.includePlannedCancellations = includePlannedCancellations;
        this.bannedRoutes = Set.copyOf(bannedRoutes);
        this.bannedTrips = Set.copyOf(bannedTrips);
        this.transitModeFilter = AllowTransitModeFilter.of(allowedTransitModes);
    }

    public RouteRequestTransitDataProviderFilter(RouteRequest request, TransitService transitService) {
        this(request.journey().transfer().mode() == StreetMode.BIKE, request.wheelchair(), request.preferences().wheelchair(), request.preferences().transit().includePlannedCancellations(), request.journey().transit().modes(), RouteRequestTransitDataProviderFilter.bannedRoutes(request.journey().transit().bannedAgencies(), request.journey().transit().bannedRoutes(), request.journey().transit().whiteListedAgencies(), request.journey().transit().whiteListedRoutes(), transitService.getAllRoutes()), request.journey().transit().bannedTrips());
    }

    public static BikeAccess bikeAccessForTrip(Trip trip) {
        if (trip.getBikesAllowed() != BikeAccess.UNKNOWN) {
            return trip.getBikesAllowed();
        }
        return trip.getRoute().getBikesAllowed();
    }

    @Override
    public boolean tripPatternPredicate(TripPatternForDate tripPatternForDate) {
        return this.bannedRoutes.isEmpty() || this.routeIsNotBanned(tripPatternForDate);
    }

    @Override
    public boolean tripTimesPredicate(TripTimes tripTimes) {
        Trip trip = tripTimes.getTrip();
        if (!this.transitModeFilter.allows(trip.getMode(), trip.getNetexSubMode())) {
            return false;
        }
        if (!this.bannedTrips.isEmpty() && this.bannedTrips.contains(trip.getId())) {
            return false;
        }
        if (this.requireBikesAllowed && RouteRequestTransitDataProviderFilter.bikeAccessForTrip(trip) != BikeAccess.ALLOWED) {
            return false;
        }
        if (this.wheelchairEnabled && this.wheelchairPreferences.trip().onlyConsiderAccessible() && tripTimes.getWheelchairAccessibility() != Accessibility.POSSIBLE) {
            return false;
        }
        return this.includePlannedCancellations || !trip.getNetexAlteration().isCanceledOrReplaced();
    }

    @Override
    public BitSet filterAvailableStops(RoutingTripPattern tripPattern, BitSet boardingPossible) {
        if (this.wheelchairEnabled && this.wheelchairPreferences.stop().onlyConsiderAccessible()) {
            BitSet copy = (BitSet)boardingPossible.clone();
            copy.and(tripPattern.getWheelchairAccessible());
            return copy;
        }
        return boardingPossible;
    }

    public static List<FeedScopedId> bannedRoutes(Collection<FeedScopedId> bannedAgenciesCollection, RouteMatcher bannedRoutes, Collection<FeedScopedId> whiteListedAgenciesCollection, RouteMatcher whiteListedRoutes, Collection<Route> routes) {
        if (bannedRoutes.isEmpty() && bannedAgenciesCollection.isEmpty() && whiteListedRoutes.isEmpty() && whiteListedAgenciesCollection.isEmpty()) {
            return List.of();
        }
        Set<FeedScopedId> bannedAgencies = Set.copyOf(bannedAgenciesCollection);
        Set<FeedScopedId> whiteListedAgencies = Set.copyOf(whiteListedAgenciesCollection);
        ArrayList<FeedScopedId> ret = new ArrayList<FeedScopedId>();
        for (Route route : routes) {
            if (!RouteRequestTransitDataProviderFilter.routeIsBanned(bannedAgencies, bannedRoutes, whiteListedAgencies, whiteListedRoutes, route)) continue;
            ret.add(route.getId());
        }
        return ret;
    }

    private static boolean routeIsBanned(Set<FeedScopedId> bannedAgencies, RouteMatcher bannedRoutes, Set<FeedScopedId> whiteListedAgencies, RouteMatcher whiteListedRoutes, Route route) {
        if (!bannedAgencies.isEmpty() && bannedAgencies.contains(route.getAgency().getId())) {
            return true;
        }
        if (!bannedRoutes.isEmpty() && bannedRoutes.matches(route)) {
            return true;
        }
        boolean whiteListed = false;
        boolean whiteListInUse = false;
        if (!whiteListedAgencies.isEmpty()) {
            whiteListInUse = true;
            if (whiteListedAgencies.contains(route.getAgency().getId())) {
                whiteListed = true;
            }
        }
        if (!whiteListedRoutes.isEmpty()) {
            whiteListInUse = true;
            if (whiteListedRoutes.matches(route)) {
                whiteListed = true;
            }
        }
        return whiteListInUse && !whiteListed;
    }

    private boolean routeIsNotBanned(TripPatternForDate tripPatternForDate) {
        FeedScopedId routeId = tripPatternForDate.getTripPattern().route().getId();
        return !this.bannedRoutes.contains(routeId);
    }
}

