/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.HashMultimap;
import gnu.trove.set.TIntSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitLayerUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TransitLayerUpdater.class);
    private final TransitModel transitModel;
    private final Map<LocalDate, TIntSet> serviceCodesRunningForDate;
    private final Map<LocalDate, Map<TripPattern, TripPatternForDate>> tripPatternsStartingOnDateMapCache = new HashMap<LocalDate, Map<TripPattern, TripPatternForDate>>();
    private final Map<TripIdAndServiceDate, TripPatternForDate> tripPatternsForTripIdAndServiceDateCache = new HashMap<TripIdAndServiceDate, TripPatternForDate>();
    private final Map<LocalDate, Set<TripPatternForDate>> tripPatternsRunningOnDateMapCache = new HashMap<LocalDate, Set<TripPatternForDate>>();

    public TransitLayerUpdater(TransitModel transitModel, Map<LocalDate, TIntSet> serviceCodesRunningForDate) {
        this.transitModel = transitModel;
        this.serviceCodesRunningForDate = serviceCodesRunningForDate;
    }

    public void update(Set<Timetable> updatedTimetables, Map<TripPattern, SortedSet<Timetable>> timetables) {
        if (!this.transitModel.hasRealtimeTransitLayer()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        TransitLayer realtimeTransitLayer = new TransitLayer(this.transitModel.getRealtimeTransitLayer());
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.serviceCodesRunningForDate);
        HashSet<LocalDate> datesToBeUpdated = new HashSet<LocalDate>();
        HashMultimap newTripPatternsForDate = HashMultimap.create();
        HashMultimap oldTripPatternsForDate = HashMultimap.create();
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = realtimeTransitLayer.getTransferIndexGenerator();
        }
        HashSet<TripPatternForDate> previouslyUsedPatterns = new HashSet<TripPatternForDate>();
        for (Timetable timetable : updatedTimetables) {
            Object newTripPatternForDate;
            TripPatternForDate oldTripPatternForDate;
            LocalDate date = timetable.getServiceDate();
            TripPattern tripPattern = timetable.getPattern();
            if (!this.tripPatternsStartingOnDateMapCache.containsKey(date)) {
                Map<TripPattern, TripPatternForDate> map = realtimeTransitLayer.getTripPatternsStartingOnDateCopy(date).stream().collect(Collectors.toMap(t -> t.getTripPattern().getPattern(), t -> t));
                this.tripPatternsStartingOnDateMapCache.put(date, map);
            }
            if ((oldTripPatternForDate = this.tripPatternsStartingOnDateMapCache.get(date).get(tripPattern)) != null) {
                this.tripPatternsStartingOnDateMapCache.get(date).remove(tripPattern, oldTripPatternForDate);
                oldTripPatternsForDate.put((Object)tripPattern, (Object)oldTripPatternForDate);
                datesToBeUpdated.addAll(oldTripPatternForDate.getRunningPeriodDates());
            }
            if ((newTripPatternForDate = tripPatternForDateMapper.map(timetable, timetable.getServiceDate())) == null) continue;
            this.tripPatternsStartingOnDateMapCache.get(date).put(tripPattern, (TripPatternForDate)newTripPatternForDate);
            newTripPatternsForDate.put((Object)tripPattern, newTripPatternForDate);
            datesToBeUpdated.addAll(((TripPatternForDate)newTripPatternForDate).getRunningPeriodDates());
            if (transferIndexGenerator != null && ((TripPatternForDate)newTripPatternForDate).getTripPattern().getPattern().isCreatedByRealtimeUpdater()) {
                transferIndexGenerator.addRealtimeTrip(tripPattern, timetable.getTripTimes().stream().map(TripTimes::getTrip).collect(Collectors.toList()));
            }
            for (TripTimes triptimes : timetable.getTripTimes()) {
                TripIdAndServiceDate id = new TripIdAndServiceDate(triptimes.getTrip().getId(), timetable.getServiceDate());
                TripPatternForDate previousTripPatternForDate = this.tripPatternsForTripIdAndServiceDateCache.put(id, (TripPatternForDate)newTripPatternForDate);
                if (previousTripPatternForDate != null) {
                    previouslyUsedPatterns.add(previousTripPatternForDate);
                    continue;
                }
                LOG.debug("NEW TripPatternForDate: {} - {}", (Object)((TripPatternForDate)newTripPatternForDate).getLocalDate(), (Object)((TripPatternForDate)newTripPatternForDate).getTripPattern().debugInfo());
            }
        }
        for (LocalDate date : datesToBeUpdated) {
            this.tripPatternsRunningOnDateMapCache.computeIfAbsent(date, p -> new HashSet<TripPatternForDate>(realtimeTransitLayer.getTripPatternsRunningOnDateCopy(date)));
            Set<TripPatternForDate> patternsForDate = this.tripPatternsRunningOnDateMapCache.get(date);
            for (Map.Entry entry : oldTripPatternsForDate.asMap().entrySet()) {
                for (TripPatternForDate oldTripPatternForDate : (Collection)entry.getValue()) {
                    if (oldTripPatternForDate == null || !oldTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                    patternsForDate.remove(oldTripPatternForDate);
                }
            }
            for (TripPatternForDate tripPatternForDate : previouslyUsedPatterns) {
                TripPattern pattern;
                if (!tripPatternForDate.getLocalDate().equals(date) || !(pattern = tripPatternForDate.getTripPattern().getPattern()).isCreatedByRealtimeUpdater()) continue;
                SortedSet<Timetable> oldTimeTable = timetables.get(pattern);
                if (oldTimeTable != null) {
                    Boolean toRemove = oldTimeTable.stream().filter(tt -> tt.getServiceDate().equals(date)).findFirst().map(tt -> tt.getTripTimes().isEmpty()).orElse(false);
                    if (!toRemove.booleanValue()) continue;
                    patternsForDate.remove(tripPatternForDate);
                    continue;
                }
                LOG.warn("Could not fetch timetable for {}", (Object)pattern);
            }
            for (Map.Entry entry : newTripPatternsForDate.asMap().entrySet()) {
                for (TripPatternForDate newTripPatternForDate : (Collection)entry.getValue()) {
                    if (newTripPatternForDate == null || !newTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                    patternsForDate.add(newTripPatternForDate);
                }
            }
            realtimeTransitLayer.replaceTripPatternsForDate(date, new ArrayList<TripPatternForDate>(patternsForDate));
        }
        if (transferIndexGenerator != null) {
            realtimeTransitLayer.setConstrainedTransfers(transferIndexGenerator.generateTransfers());
        }
        this.transitModel.setRealtimeTransitLayer(realtimeTransitLayer);
        LOG.debug("UPDATING {} tripPatterns took {} ms", (Object)updatedTimetables.size(), (Object)(System.currentTimeMillis() - startTime));
    }
}

