/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import io.micrometer.core.instrument.MeterRegistry;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.routing.algorithm.raptoradapter.router.performance.PerformanceTimersForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.SlackProvider;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.transit.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.Optimization;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.rangeraptor.SystemErrDebugLogger;
import org.opentripplanner.util.OTPFeature;

public class RaptorRequestMapper {
    private final RouteRequest request;
    private final Collection<? extends RaptorAccessEgress> accessPaths;
    private final Collection<? extends RaptorAccessEgress> egressPaths;
    private final long transitSearchTimeZeroEpocSecond;
    private final boolean isMultiThreadedEnbled;
    private final MeterRegistry meterRegistry;

    private RaptorRequestMapper(RouteRequest request, boolean isMultiThreaded, Collection<? extends RaptorAccessEgress> accessPaths, Collection<? extends RaptorAccessEgress> egressPaths, long transitSearchTimeZeroEpocSecond, MeterRegistry meterRegistry) {
        this.request = request;
        this.isMultiThreadedEnbled = isMultiThreaded;
        this.accessPaths = accessPaths;
        this.egressPaths = egressPaths;
        this.transitSearchTimeZeroEpocSecond = transitSearchTimeZeroEpocSecond;
        this.meterRegistry = meterRegistry;
    }

    public static RaptorRequest<TripSchedule> mapRequest(RouteRequest request, ZonedDateTime transitSearchTimeZero, boolean isMultiThreaded, Collection<? extends RaptorAccessEgress> accessPaths, Collection<? extends RaptorAccessEgress> egressPaths, MeterRegistry meterRegistry) {
        return new RaptorRequestMapper(request, isMultiThreaded, accessPaths, egressPaths, transitSearchTimeZero.toEpochSecond(), meterRegistry).doMap();
    }

    private RaptorRequest<TripSchedule> doMap() {
        RaptorRequestBuilder builder = new RaptorRequestBuilder();
        SearchParamsBuilder searchParams = builder.searchParams();
        RoutingPreferences preferences = this.request.preferences();
        if (this.request.pageCursor() == null) {
            int time = this.relativeTime(this.request.dateTime());
            int timeLimit = this.relativeTime(preferences.transit().raptor().timeLimit());
            if (this.request.arriveBy()) {
                searchParams.latestArrivalTime(time);
                searchParams.earliestDepartureTime(timeLimit);
            } else {
                searchParams.earliestDepartureTime(time);
                searchParams.latestArrivalTime(timeLimit);
            }
            searchParams.searchWindow(this.request.searchWindow());
        } else {
            PageCursor c = this.request.pageCursor();
            if (c.earliestDepartureTime != null) {
                searchParams.earliestDepartureTime(this.relativeTime(c.earliestDepartureTime));
            }
            if (c.latestArrivalTime != null) {
                searchParams.latestArrivalTime(this.relativeTime(c.latestArrivalTime));
            }
            searchParams.searchWindow(c.searchWindow);
        }
        if (preferences.transfer().maxTransfers() != null) {
            searchParams.maxNumberOfTransfers(preferences.transfer().maxTransfers());
        }
        for (Optimization optimization : preferences.transit().raptor().optimizations()) {
            if (optimization.is(Optimization.PARALLEL)) {
                if (!this.isMultiThreadedEnbled) continue;
                builder.enableOptimization(optimization);
                continue;
            }
            builder.enableOptimization(optimization);
        }
        builder.profile(preferences.transit().raptor().profile());
        builder.searchDirection(preferences.transit().raptor().searchDirection());
        builder.profile(RaptorProfile.MULTI_CRITERIA).enableOptimization(Optimization.PARETO_CHECK_AGAINST_DESTINATION).slackProvider(new SlackProvider(preferences.transfer().slack(), preferences.transit().boardSlack(), preferences.transit().alightSlack()));
        builder.searchParams().timetableEnabled(this.request.timetableView()).constrainedTransfersEnabled(OTPFeature.TransferConstraints.isOn()).addAccessPaths(this.accessPaths).addEgressPaths(this.egressPaths);
        DebugRaptor raptorDebugging = this.request.journey().transit().raptorDebugging();
        if (raptorDebugging.isEnabled()) {
            DebugRequestBuilder debug = builder.debug();
            SystemErrDebugLogger debugLogger = new SystemErrDebugLogger(true);
            debug.addStops(raptorDebugging.stops()).setPath(raptorDebugging.path()).debugPathFromStopIndex(raptorDebugging.debugPathFromStopIndex()).stopArrivalListener(debugLogger::stopArrivalLister).patternRideDebugListener(debugLogger::patternRideLister).pathFilteringListener(debugLogger::pathFilteringListener).logger(debugLogger);
        }
        if (!this.request.timetableView() && this.request.arriveBy()) {
            builder.searchParams().preferLateArrival(true);
        }
        builder.performanceTimers(new PerformanceTimersForRaptor(builder.generateAlias(), preferences.system().tags(), this.meterRegistry));
        return builder.build();
    }

    private int relativeTime(Instant time) {
        if (time == null) {
            return -9999999;
        }
        return (int)(time.getEpochSecond() - this.transitSearchTimeZeroEpocSecond);
    }
}

