/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency;

import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.FrequencyAlightEvent;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;

public final class TripFrequencyAlightSearch<T extends DefaultTripSchedule>
implements RaptorTripScheduleSearch<T> {
    private final TripPatternForDates patternForDates;

    public TripFrequencyAlightSearch(TripPatternForDates patternForDates) {
        this.patternForDates = patternForDates;
    }

    @Override
    public RaptorTripScheduleBoardOrAlightEvent<T> search(int earliestBoardTime, int stopPositionInPattern, int tripIndexLimit) {
        IntIterator indexIterator = this.patternForDates.tripPatternForDatesIndexIterator(false);
        while (indexIterator.hasNext()) {
            int i = indexIterator.next();
            TripPatternForDate pattern = this.patternForDates.tripPatternForDate(i);
            int offset = this.patternForDates.tripPatternForDateOffsets(i);
            for (int j = pattern.getFrequencies().size() - 1; j >= 0; --j) {
                FrequencyEntry frequency = pattern.getFrequencies().get(j);
                int arrivalTime = frequency.prevArrivalTime(stopPositionInPattern, earliestBoardTime - offset);
                if (arrivalTime == -1) continue;
                int headway = frequency.exactTimes ? 0 : frequency.headway;
                TripTimes tripTimes = frequency.materialize(stopPositionInPattern, arrivalTime + headway, false);
                return new FrequencyAlightEvent(this.patternForDates, tripTimes, stopPositionInPattern, arrivalTime + headway, headway, offset, pattern.getLocalDate());
            }
        }
        return null;
    }
}

