/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency;

import java.time.LocalDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;

abstract class FrequencyBoardOrAlightEvent<T extends DefaultTripSchedule>
implements RaptorTripScheduleBoardOrAlightEvent<T>,
TripSchedule {
    protected final TripPatternForDates raptorTripPattern;
    protected final TripTimes tripTimes;
    protected final int stopPositionInPattern;
    protected final int departureTime;
    protected final int offset;
    protected final int headway;
    protected final LocalDate serviceDate;
    private final Accessibility wheelChairBoarding;

    public FrequencyBoardOrAlightEvent(TripPatternForDates raptorTripPattern, TripTimes tripTimes, int stopPositionInPattern, int departureTime, int offset, int headway, LocalDate serviceDate) {
        this.raptorTripPattern = raptorTripPattern;
        this.tripTimes = tripTimes;
        this.stopPositionInPattern = stopPositionInPattern;
        this.departureTime = departureTime;
        this.offset = offset;
        this.headway = headway;
        this.serviceDate = serviceDate;
        this.wheelChairBoarding = tripTimes.getWheelchairAccessibility();
    }

    @Override
    public int getTripIndex() {
        return this.tripTimes.getDepartureTime(0) + this.offset;
    }

    @Override
    public T getTrip() {
        return (T)this;
    }

    @Override
    public int getStopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    public int getTime() {
        return this.departureTime + this.offset;
    }

    @Override
    public RaptorTransferConstraint getTransferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    @Override
    public int tripSortIndex() {
        return this.tripTimes.getDepartureTime(0) + this.offset;
    }

    @Override
    public abstract int arrival(int var1);

    @Override
    public abstract int departure(int var1);

    @Override
    public RaptorTripPattern pattern() {
        return this.raptorTripPattern;
    }

    @Override
    public int transitReluctanceFactorIndex() {
        return this.raptorTripPattern.transitReluctanceFactorIndex();
    }

    @Override
    public TripTimes getOriginalTripTimes() {
        return this.tripTimes;
    }

    @Override
    public TripPattern getOriginalTripPattern() {
        return this.raptorTripPattern.getTripPattern().getPattern();
    }

    @Override
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public boolean isFrequencyBasedTrip() {
        return true;
    }

    @Override
    public int frequencyHeadwayInSeconds() {
        return this.headway;
    }

    @Override
    public Accessibility wheelchairBoarding() {
        return this.wheelChairBoarding;
    }
}

