/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.BitSet;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;

public class PatternCostCalculator<T extends DefaultTripSchedule>
implements CostCalculator<T> {
    public static final double DEFAULT_ROUTE_RELUCTANCE = 1.0;
    public static final double UNPREFERRED_ROUTE_RELUCTANCE = 2.0;
    private final CostCalculator<T> delegate;
    private final BitSet unpreferredPatterns;
    private final DoubleAlgorithmFunction unpreferredCost;

    public PatternCostCalculator(@Nonnull CostCalculator<T> delegate, @Nonnull BitSet unpreferredPatterns, @Nonnull DoubleAlgorithmFunction unpreferredCost) {
        this.unpreferredPatterns = unpreferredPatterns;
        this.delegate = delegate;
        this.unpreferredCost = unpreferredCost;
    }

    @Override
    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        return this.delegate.boardingCost(firstBoarding, prevArrivalTime, boardStop, boardTime, trip, transferConstraints);
    }

    @Override
    public int onTripRelativeRidingCost(int boardTime, T tripScheduledBoarded) {
        return this.delegate.onTripRelativeRidingCost(boardTime, tripScheduledBoarded);
    }

    @Override
    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        int unpreferCost = 0;
        if (this.unpreferredPatterns.get(trip.pattern().patternIndex())) {
            unpreferCost += RaptorCostConverter.toRaptorCost(this.unpreferredCost.calculate(transitTime));
        }
        int defaultCost = this.delegate.transitArrivalCost(boardCost, alightSlack, transitTime, trip, toStop);
        return defaultCost + unpreferCost;
    }

    @Override
    public int waitCost(int waitTimeInSeconds) {
        return this.delegate.waitCost(waitTimeInSeconds);
    }

    @Override
    public int calculateMinCost(int minTravelTime, int minNumTransfers) {
        return this.delegate.calculateMinCost(minTravelTime, minNumTransfers);
    }

    @Override
    public int costEgress(RaptorAccessEgress egress) {
        return this.delegate.costEgress(egress);
    }
}

