/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import javax.annotation.Nullable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointMatcher;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;

public class TransferForPattern
implements Comparable<TransferForPattern> {
    private final TransferPointMatcher sourcePoint;
    @Nullable
    private final Trip targetTrip;
    private final RaptorTransferConstraint transferConstraint;
    private final int specificityRanking;

    TransferForPattern(TransferPointMatcher sourcePoint, @Nullable Trip targetTrip, int specificityRanking, RaptorTransferConstraint transferConstraint) {
        this.sourcePoint = sourcePoint;
        this.targetTrip = targetTrip;
        this.specificityRanking = specificityRanking;
        this.transferConstraint = transferConstraint;
    }

    public RaptorTransferConstraint getTransferConstraint() {
        return this.transferConstraint;
    }

    public boolean matchesSourcePoint(int stopIndex, Trip trip) {
        return this.sourcePoint.match(stopIndex, trip);
    }

    public boolean applyToAllTargetTrips() {
        return this.targetTrip == null;
    }

    public boolean applyToTargetTrip(Trip targetTrip) {
        return this.targetTrip == targetTrip;
    }

    @Override
    public int compareTo(TransferForPattern o) {
        return o.specificityRanking - this.specificityRanking;
    }
}

