/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.util.time.ServiceDateUtils;

public class TripPatternForDate {
    private final RoutingTripPattern tripPattern;
    private final List<TripTimes> tripTimes;
    private final List<FrequencyEntry> frequencies;
    private final LocalDate localDate;
    private final LocalDateTime startOfRunningPeriod;
    private final LocalDateTime endOfRunningPeriod;

    public TripPatternForDate(RoutingTripPattern tripPattern, List<TripTimes> tripTimes, List<FrequencyEntry> frequencies, LocalDate localDate) {
        this.tripPattern = tripPattern;
        this.tripTimes = List.copyOf(tripTimes);
        this.frequencies = List.copyOf(frequencies);
        this.localDate = localDate;
        if (this.hasFrequencies()) {
            this.startOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, frequencies.stream().mapToInt(frequencyEntry -> frequencyEntry.startTime).min().orElseThrow());
            this.endOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, frequencies.stream().mapToInt(frequencyEntry -> frequencyEntry.endTime).max().orElseThrow());
        } else {
            this.startOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, tripTimes.get(0).getDepartureTime(0));
            TripTimes last = tripTimes.get(tripTimes.size() - 1);
            this.endOfRunningPeriod = ServiceDateUtils.asDateTime(localDate, last.getArrivalTime(last.getNumStops() - 1));
        }
    }

    public List<TripTimes> tripTimes() {
        return this.tripTimes;
    }

    public List<FrequencyEntry> getFrequencies() {
        return this.frequencies;
    }

    public RoutingTripPattern getTripPattern() {
        return this.tripPattern;
    }

    public int stopIndex(int i) {
        return this.tripPattern.stopIndex(i);
    }

    public TripTimes getTripTimes(int i) {
        return this.tripTimes.get(i);
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public int numberOfTripSchedules() {
        return this.tripTimes.size();
    }

    public LocalDateTime getStartOfRunningPeriod() {
        return this.startOfRunningPeriod;
    }

    public List<LocalDate> getRunningPeriodDates() {
        return this.startOfRunningPeriod.toLocalDate().datesUntil(this.endOfRunningPeriod.toLocalDate().plusDays(1L)).collect(Collectors.toList());
    }

    public boolean hasFrequencies() {
        return !this.frequencies.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.tripPattern, this.tripTimes, this.localDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripPatternForDate that = (TripPatternForDate)o;
        return this.tripPattern.equals(that.tripPattern) && this.localDate.equals(that.localDate) && this.tripTimes.equals(that.tripTimes);
    }

    public String toString() {
        return "TripPatternForDate{tripPattern=" + this.tripPattern + ", localDate=" + this.localDate + "}";
    }

    @Nullable
    public TripPatternForDate newWithFilteredTripTimes(Predicate<TripTimes> filter) {
        ArrayList<TripTimes> filteredTripTimes = new ArrayList<TripTimes>(this.tripTimes.size());
        for (TripTimes tripTimes : this.tripTimes) {
            if (!filter.test(tripTimes)) continue;
            filteredTripTimes.add(tripTimes);
        }
        ArrayList<FrequencyEntry> filteredFrequencies = new ArrayList<FrequencyEntry>(this.frequencies.size());
        for (FrequencyEntry frequencyEntry : this.frequencies) {
            if (!filter.test(frequencyEntry.tripTimes)) continue;
            filteredFrequencies.add(frequencyEntry);
        }
        if (filteredTripTimes.isEmpty() && filteredFrequencies.isEmpty()) {
            return null;
        }
        if (this.tripTimes.size() == filteredTripTimes.size() && this.frequencies.size() == filteredFrequencies.size()) {
            return this;
        }
        return new TripPatternForDate(this.tripPattern, filteredTripTimes, filteredFrequencies, this.localDate);
    }
}

