/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.StopModel;

public class TransitLayer {
    private final HashMap<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate;
    private final List<List<Transfer>> transfersByStopIndex;
    private final TransferService transferService;
    private final StopModel stopModel;
    private final ZoneId transitDataZoneId;
    private final RaptorRequestTransferCache transferCache;
    private ConstrainedTransfersForPatterns constrainedTransfers;
    private final TransferIndexGenerator transferIndexGenerator;
    private final int[] stopBoardAlightCosts;

    public TransitLayer(TransitLayer transitLayer) {
        this(transitLayer.tripPatternsRunningOnDate, transitLayer.transfersByStopIndex, transitLayer.transferService, transitLayer.stopModel, transitLayer.transitDataZoneId, transitLayer.transferCache, transitLayer.constrainedTransfers, transitLayer.transferIndexGenerator, transitLayer.stopBoardAlightCosts);
    }

    public TransitLayer(Map<LocalDate, List<TripPatternForDate>> tripPatternsRunningOnDate, List<List<Transfer>> transfersByStopIndex, TransferService transferService, StopModel stopModel, ZoneId transitDataZoneId, RaptorRequestTransferCache transferCache, ConstrainedTransfersForPatterns constrainedTransfers, TransferIndexGenerator transferIndexGenerator, int[] stopBoardAlightCosts) {
        this.tripPatternsRunningOnDate = new HashMap<LocalDate, List<TripPatternForDate>>(tripPatternsRunningOnDate);
        this.transfersByStopIndex = transfersByStopIndex;
        this.transferService = transferService;
        this.stopModel = stopModel;
        this.transitDataZoneId = transitDataZoneId;
        this.transferCache = transferCache;
        this.constrainedTransfers = constrainedTransfers;
        this.transferIndexGenerator = transferIndexGenerator;
        this.stopBoardAlightCosts = stopBoardAlightCosts;
    }

    @Nullable
    public StopLocation getStopByIndex(int stop) {
        return stop == -1 ? null : this.stopModel.stopByIndex(stop);
    }

    public Collection<TripPatternForDate> getTripPatternsForDate(LocalDate date) {
        return this.tripPatternsRunningOnDate.getOrDefault(date, List.of());
    }

    public ZoneId getTransitDataZoneId() {
        return this.transitDataZoneId;
    }

    public int getStopCount() {
        return this.stopModel.stopIndexSize();
    }

    public List<TripPatternForDate> getTripPatternsRunningOnDateCopy(LocalDate runningPeriodDate) {
        List<TripPatternForDate> tripPatternForDate = this.tripPatternsRunningOnDate.get(runningPeriodDate);
        return tripPatternForDate != null ? new ArrayList<TripPatternForDate>(tripPatternForDate) : new ArrayList();
    }

    public List<TripPatternForDate> getTripPatternsStartingOnDateCopy(LocalDate date) {
        List<TripPatternForDate> tripPatternsRunningOnDate = this.getTripPatternsRunningOnDateCopy(date);
        return tripPatternsRunningOnDate.stream().filter(t -> t.getLocalDate().equals(date)).collect(Collectors.toList());
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public RaptorTransferIndex getRaptorTransfersForRequest(RouteRequest request) {
        return this.transferCache.get(this.transfersByStopIndex, request);
    }

    public RaptorRequestTransferCache getTransferCache() {
        return this.transferCache;
    }

    public List<TransferForPatternByStopPos> getForwardConstrainedTransfers() {
        return this.constrainedTransfers != null ? this.constrainedTransfers.forward() : null;
    }

    public List<TransferForPatternByStopPos> getReverseConstrainedTransfers() {
        return this.constrainedTransfers != null ? this.constrainedTransfers.reverse() : null;
    }

    public TransferIndexGenerator getTransferIndexGenerator() {
        return this.transferIndexGenerator;
    }

    public int[] getStopBoardAlightCosts() {
        return this.stopBoardAlightCosts;
    }

    public void replaceTripPatternsForDate(LocalDate date, List<TripPatternForDate> tripPatternForDates) {
        this.tripPatternsRunningOnDate.replace(date, tripPatternForDates);
    }

    public void setConstrainedTransfers(ConstrainedTransfersForPatterns constrainedTransfers) {
        this.constrainedTransfers = constrainedTransfers;
    }
}

