/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.AStarRequestMapper;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;

public class RaptorTransferIndex {
    private final List<RaptorTransfer>[] forwardTransfers;
    private final List<RaptorTransfer>[] reversedTransfers;

    public RaptorTransferIndex(List<List<RaptorTransfer>> forwardTransfers, List<List<RaptorTransfer>> reversedTransfers) {
        this.forwardTransfers = (List[])forwardTransfers.stream().map(List::copyOf).toArray(List[]::new);
        this.reversedTransfers = (List[])reversedTransfers.stream().map(List::copyOf).toArray(List[]::new);
    }

    public static RaptorTransferIndex create(List<List<Transfer>> transfersByStopIndex, RouteRequest request) {
        ArrayList<List<RaptorTransfer>> forwardTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        ArrayList<List<RaptorTransfer>> reversedTransfers = new ArrayList<List<RaptorTransfer>>(transfersByStopIndex.size());
        for (int i = 0; i < transfersByStopIndex.size(); ++i) {
            forwardTransfers.add(new ArrayList());
            reversedTransfers.add(new ArrayList());
        }
        AStarRequest aStarRequest = AStarRequestMapper.map(request).withMode(request.journey().transfer().mode()).build();
        for (int fromStop = 0; fromStop < transfersByStopIndex.size(); ++fromStop) {
            Collection transfers = transfersByStopIndex.get(fromStop).stream().flatMap(s -> s.asRaptorTransfer(aStarRequest).stream()).collect(Collectors.toMap(RaptorTransfer::stop, Function.identity(), (a, b) -> a.generalizedCost() < b.generalizedCost() ? a : b)).values();
            forwardTransfers.get(fromStop).addAll(transfers);
            for (RaptorTransfer forwardTransfer : transfers) {
                reversedTransfers.get(forwardTransfer.stop()).add(DefaultRaptorTransfer.reverseOf(fromStop, forwardTransfer));
            }
        }
        return new RaptorTransferIndex(forwardTransfers, reversedTransfers);
    }

    public List<RaptorTransfer> getForwardTransfers(int stopIndex) {
        return this.forwardTransfers[stopIndex];
    }

    public List<RaptorTransfer> getReversedTransfers(int stopIndex) {
        return this.reversedTransfers[stopIndex];
    }
}

