/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.util.Collections;
import java.util.List;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.mapping.ItinerariesHelper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.TemporaryVerticesContainer;
import org.opentripplanner.routing.error.PathNotFoundException;
import org.opentripplanner.routing.impl.GraphPathFinder;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class DirectStreetRouter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Itinerary> route(OtpServerRequestContext serverContext, RouteRequest request) {
        if (request.journey().direct().mode() == StreetMode.NOT_SET) {
            return Collections.emptyList();
        }
        RouteRequest directRequest = request.clone();
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(serverContext.graph(), directRequest, request.journey().direct().mode(), request.journey().direct().mode());){
            if (!DirectStreetRouter.straightLineDistanceIsWithinLimit(directRequest, temporaryVertices)) {
                List<Itinerary> list = Collections.emptyList();
                return list;
            }
            GraphPathFinder gpFinder = new GraphPathFinder(serverContext.traverseVisitor(), serverContext.routerConfig().streetRoutingTimeout(), serverContext.dataOverlayContext(request));
            List<GraphPath> paths = gpFinder.graphPathFinderEntryPoint(directRequest, temporaryVertices);
            GraphPathToItineraryMapper graphPathToItineraryMapper = new GraphPathToItineraryMapper(serverContext.transitService().getTimeZone(), serverContext.graph().streetNotesService, serverContext.graph().ellipsoidToGeoidDifference);
            List<Itinerary> response = graphPathToItineraryMapper.mapItineraries(paths);
            ItinerariesHelper.decorateItinerariesWithRequestData(response, directRequest.wheelchair(), directRequest.preferences().wheelchair());
            List<Itinerary> list = response;
            return list;
        }
        catch (PathNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private static boolean straightLineDistanceIsWithinLimit(RouteRequest request, TemporaryVerticesContainer vertexContainer) {
        double distance = SphericalDistanceLibrary.distance(vertexContainer.getFromVertices().iterator().next().getCoordinate(), vertexContainer.getToVertices().iterator().next().getCoordinate());
        return distance < DirectStreetRouter.calculateDistanceMaxLimit(request);
    }

    private static double calculateDistanceMaxLimit(RouteRequest request) {
        double distanceLimit;
        RoutingPreferences preferences = request.preferences();
        StreetMode mode = request.journey().direct().mode();
        double durationLimit = preferences.street().maxDirectDuration().valueOf(mode).toSeconds();
        if (mode.includesDriving()) {
            distanceLimit = durationLimit * preferences.car().speed();
        } else if (mode.includesBiking()) {
            distanceLimit = durationLimit * preferences.bike().speed();
        } else if (mode.includesWalking()) {
            distanceLimit = durationLimit * preferences.walk().speed();
        } else {
            throw new IllegalStateException("Could not set max limit for StreetMode");
        }
        return distanceLimit;
    }
}

