/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.groupids;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupId;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GroupByAllSameStations
implements GroupId<GroupByAllSameStations> {
    private final List<P2<FeedScopedId>> keySet;

    public GroupByAllSameStations(Itinerary itinerary) {
        this.keySet = itinerary.getLegs().stream().filter(Leg::isTransitLeg).map(leg -> new P2<FeedScopedId>(leg.getFrom().stop.getStationOrStopId(), leg.getTo().stop.getStationOrStopId())).collect(Collectors.toList());
    }

    @Override
    public boolean match(GroupByAllSameStations other) {
        if (this == other) {
            return true;
        }
        if (this.keySet.isEmpty() || other.keySet.isEmpty()) {
            return false;
        }
        return this.keySet.equals(other.keySet);
    }

    @Override
    public GroupByAllSameStations merge(GroupByAllSameStations other) {
        return this;
    }
}

