/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;

public class NonTransitGeneralizedCostFilter
implements ItineraryDeletionFlagger {
    private final DoubleAlgorithmFunction costLimitFunction;

    public NonTransitGeneralizedCostFilter(DoubleAlgorithmFunction costLimitFunction) {
        this.costLimitFunction = costLimitFunction;
    }

    @Override
    public String name() {
        return "non-transit-cost-filter";
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        OptionalDouble minGeneralizedCost = itineraries.stream().mapToDouble(Itinerary::getGeneralizedCost).min();
        if (minGeneralizedCost.isEmpty()) {
            return List.of();
        }
        double maxLimit = this.costLimitFunction.calculate(minGeneralizedCost.getAsDouble());
        return itineraries.stream().filter(it -> !it.hasTransit() && (double)it.getGeneralizedCost() > maxLimit).collect(Collectors.toList());
    }
}

