/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.astar;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.common.pqueue.BinHeap;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.algorithm.astar.strategies.SearchTerminationStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.util.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AStar {
    private static final Logger LOG = LoggerFactory.getLogger(AStar.class);
    private static final boolean verbose = LOG.isDebugEnabled();
    private final boolean arriveBy;
    private final Set<Vertex> fromVertices;
    private final Set<Vertex> toVertices;
    private final RemainingWeightHeuristic heuristic;
    private final SkipEdgeStrategy skipEdgeStrategy;
    private final SearchTerminationStrategy terminationStrategy;
    private final TraverseVisitor traverseVisitor;
    private final Duration timeout;
    private final ShortestPathTree spt;
    private final BinHeap<State> pq;
    private final List<State> targetAcceptedStates;
    private State u;
    private int nVisited;

    protected AStar(RemainingWeightHeuristic heuristic, SkipEdgeStrategy skipEdgeStrategy, TraverseVisitor traverseVisitor, boolean arriveBy, Set<Vertex> fromVertices, Set<Vertex> toVertices, SearchTerminationStrategy terminationStrategy, DominanceFunction dominanceFunction, Duration timeout, Collection<State> initialStates) {
        this.heuristic = heuristic;
        this.skipEdgeStrategy = skipEdgeStrategy;
        this.traverseVisitor = traverseVisitor;
        this.fromVertices = fromVertices;
        this.toVertices = toVertices;
        this.arriveBy = arriveBy;
        this.terminationStrategy = terminationStrategy;
        this.timeout = timeout;
        this.spt = new ShortestPathTree(dominanceFunction);
        this.pq = new BinHeap(1000);
        this.nVisited = 0;
        this.targetAcceptedStates = new ArrayList<State>();
        for (State initialState : initialStates) {
            this.spt.add(initialState);
            this.pq.insert(initialState, initialState.weight);
        }
    }

    protected ShortestPathTree getShortestPathTree() {
        this.runSearch();
        return this.spt;
    }

    protected List<GraphPath> getPathsToTarget() {
        this.runSearch();
        return this.targetAcceptedStates.stream().filter(State::isFinal).map(GraphPath::new).collect(Collectors.toList());
    }

    private boolean iterate() {
        if (verbose) {
            double w = this.pq.peek_min_key();
            LOG.debug("pq min key = {}", (Object)w);
        }
        this.u = this.pq.extract_min();
        if (!this.spt.visit(this.u)) {
            return false;
        }
        if (this.traverseVisitor != null) {
            this.traverseVisitor.visitVertex(this.u);
        }
        ++this.nVisited;
        Vertex u_vertex = this.u.getVertex();
        if (verbose) {
            LOG.debug("   vertex {}", (Object)u_vertex);
        }
        Collection<Edge> edges = this.arriveBy ? u_vertex.getIncoming() : u_vertex.getOutgoing();
        for (Edge edge : edges) {
            if (this.skipEdgeStrategy != null && this.skipEdgeStrategy.shouldSkipEdge(this.u, edge)) continue;
            for (State v = edge.traverse(this.u); v != null; v = v.getNextResult()) {
                double remaining_w;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEdge(edge);
                }
                if ((remaining_w = this.heuristic.estimateRemainingWeight(v)) < 0.0 || Double.isInfinite(remaining_w)) continue;
                double estimate = v.getWeight() + remaining_w;
                if (verbose) {
                    LOG.debug("      edge {}", (Object)edge);
                    LOG.debug("      {} -> {}(w) + {}(heur) = {} vert = {}", new Object[]{this.u.getWeight(), v.getWeight(), remaining_w, estimate, v.getVertex()});
                }
                if (!this.spt.add(v)) continue;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEnqueue();
                }
                this.pq.insert(v, estimate);
            }
        }
        return true;
    }

    private void runSearch() {
        long abortTime = DateUtils.absoluteTimeout(this.timeout);
        while (!this.pq.empty()) {
            if (this.timeout != null && this.nVisited % 100 == 0 && System.currentTimeMillis() > abortTime) {
                LOG.warn("Search timeout. origin={} target={}", this.fromVertices, this.toVertices);
                this.spt.setAborted();
                break;
            }
            if (!this.iterate()) continue;
            if (this.terminationStrategy != null && this.terminationStrategy.shouldSearchTerminate(this.u)) break;
            if (this.toVertices == null || !this.toVertices.contains(this.u.getVertex()) || !this.u.isFinal()) continue;
            this.targetAcceptedStates.add(this.u);
            LOG.debug("total vertices visited {}", (Object)this.nVisited);
            break;
        }
    }
}

