/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.PagingSearchWindowAdjuster;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.mapping.RouteRequestToFilterChainMapper;
import org.opentripplanner.routing.algorithm.mapping.RoutingResponseMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.FilterTransitWhenDirectModeIsEmpty;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouterResult;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.DirectFlexRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.DirectStreetRouter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.transit.raptor.api.request.DynamicSearchWindowCoefficients;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.transit.raptor.api.request.SearchParams;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingWorker {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingWorker.class);
    public final DebugTimingAggregator debugTimingAggregator;
    public final PagingSearchWindowAdjuster pagingSearchWindowAdjuster;
    private final RouteRequest request;
    private final OtpServerRequestContext serverContext;
    private final ZonedDateTime transitSearchTimeZero;
    private final AdditionalSearchDays additionalSearchDays;
    private SearchParams raptorSearchParamsUsed = null;
    private Itinerary firstRemovedItinerary = null;

    public RoutingWorker(OtpServerRequestContext serverContext, RouteRequest request, ZoneId zoneId) {
        request.applyPageCursor();
        this.request = request;
        this.serverContext = serverContext;
        this.debugTimingAggregator = new DebugTimingAggregator(serverContext.meterRegistry(), request.preferences().system().tags());
        this.transitSearchTimeZero = ServiceDateUtils.asStartOfService(request.dateTime(), zoneId);
        this.pagingSearchWindowAdjuster = this.createPagingSearchWindowAdjuster(serverContext.routerConfig());
        this.additionalSearchDays = RoutingWorker.createAdditionalSearchDays(serverContext.routerConfig().raptorTuningParameters(), zoneId, request);
    }

    public RoutingResponse route() {
        FilterTransitWhenDirectModeIsEmpty emptyDirectModeHandler = new FilterTransitWhenDirectModeIsEmpty(this.request.journey().direct().mode());
        this.request.journey().direct().setMode(emptyDirectModeHandler.resolveDirectMode());
        this.debugTimingAggregator.finishedPrecalculating();
        List<Itinerary> itineraries = Collections.synchronizedList(new ArrayList());
        Set<RoutingError> routingErrors = Collections.synchronizedSet(new HashSet());
        if (OTPFeature.ParallelRouting.isOn()) {
            try {
                CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.routeDirectStreet(itineraries, routingErrors)), CompletableFuture.runAsync(() -> this.routeDirectFlex(itineraries, routingErrors)), CompletableFuture.runAsync(() -> this.routeTransit(itineraries, routingErrors))).join();
            }
            catch (CompletionException e) {
                RoutingValidationException.unwrapAndRethrowCompletionException(e);
            }
        } else {
            this.routeDirectStreet(itineraries, routingErrors);
            this.routeDirectFlex(itineraries, routingErrors);
            this.routeTransit(itineraries, routingErrors);
        }
        this.debugTimingAggregator.finishedRouting();
        boolean removeWalkAllTheWayResultsFromDirectFlex = this.request.journey().direct().mode() == StreetMode.FLEXIBLE;
        ItineraryListFilterChain filterChain = RouteRequestToFilterChainMapper.createFilterChain(this.request.itinerariesSortOrder(), this.request.preferences().itineraryFilter(), this.request.numItineraries(), this.filterOnLatestDepartureTime(), emptyDirectModeHandler.removeWalkAllTheWayResults() || removeWalkAllTheWayResultsFromDirectFlex, this.request.maxNumberOfItinerariesCropHead(), it -> {
            this.firstRemovedItinerary = it;
        }, this.request.wheelchair(), this.request.preferences().wheelchair().maxSlope(), this.serverContext.graph().getFareService(), this.serverContext.transitService().getTransitAlertService(), this.serverContext.transitService()::getMultiModalStationForStation);
        List<Itinerary> filteredItineraries = filterChain.filter(itineraries);
        routingErrors.addAll(filterChain.getRoutingErrors());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return TripPlan with {} filtered itineraries out of {} total.", (Object)filteredItineraries.stream().filter(it -> !it.isFlaggedForDeletion()).count(), (Object)itineraries.size());
        }
        this.debugTimingAggregator.finishedFiltering();
        this.request.journey().direct().setMode(emptyDirectModeHandler.originalDirectMode());
        Duration searchWindowNextSearch = this.calculateSearchWindowNextSearch(filteredItineraries);
        return RoutingResponseMapper.map(this.request, this.transitSearchTimeZero, this.raptorSearchParamsUsed, searchWindowNextSearch, this.firstRemovedItinerary, filteredItineraries, routingErrors, this.debugTimingAggregator);
    }

    private static AdditionalSearchDays createAdditionalSearchDays(RaptorTuningParameters raptorTuningParameters, ZoneId zoneId, RouteRequest request) {
        ZonedDateTime searchDateTime = ZonedDateTime.ofInstant(request.dateTime(), zoneId);
        Duration maxWindow = Duration.ofMinutes(raptorTuningParameters.dynamicSearchWindowCoefficients().maxWinTimeMinutes());
        return new AdditionalSearchDays(request.arriveBy(), searchDateTime, request.searchWindow(), maxWindow, request.preferences().system().maxJourneyDuration());
    }

    private Instant filterOnLatestDepartureTime() {
        if (!this.request.arriveBy() && this.raptorSearchParamsUsed != null && this.raptorSearchParamsUsed.isSearchWindowSet() && this.raptorSearchParamsUsed.isEarliestDepartureTimeSet()) {
            int ldt = this.raptorSearchParamsUsed.earliestDepartureTime() + this.raptorSearchParamsUsed.searchWindowInSeconds();
            return this.transitSearchTimeZero.plusSeconds(ldt).toInstant();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void routeDirectStreet(List<Itinerary> itineraries, Collection<RoutingError> routingErrors) {
        this.debugTimingAggregator.startedDirectStreetRouter();
        try {
            itineraries.addAll(DirectStreetRouter.route(this.serverContext, this.request));
        }
        catch (RoutingValidationException e) {
            routingErrors.addAll(e.getRoutingErrors());
        }
        finally {
            this.debugTimingAggregator.finishedDirectStreetRouter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void routeDirectFlex(List<Itinerary> itineraries, Collection<RoutingError> routingErrors) {
        if (!OTPFeature.FlexRouting.isOn()) {
            return;
        }
        this.debugTimingAggregator.startedDirectFlexRouter();
        try {
            itineraries.addAll(DirectFlexRouter.route(this.serverContext, this.request, this.additionalSearchDays));
        }
        catch (RoutingValidationException e) {
            routingErrors.addAll(e.getRoutingErrors());
        }
        finally {
            this.debugTimingAggregator.finishedDirectFlexRouter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void routeTransit(List<Itinerary> itineraries, Collection<RoutingError> routingErrors) {
        this.debugTimingAggregator.startedTransitRouting();
        try {
            TransitRouterResult transitResults = TransitRouter.route(this.request, this.serverContext, this.transitSearchTimeZero, this.additionalSearchDays, this.debugTimingAggregator);
            this.raptorSearchParamsUsed = transitResults.getSearchParams();
            itineraries.addAll(transitResults.getItineraries());
        }
        catch (RoutingValidationException e) {
            routingErrors.addAll(e.getRoutingErrors());
        }
        finally {
            this.debugTimingAggregator.finishedTransitRouter();
        }
    }

    private Duration calculateSearchWindowNextSearch(List<Itinerary> itineraries) {
        if (this.raptorSearchParamsUsed == null) {
            return null;
        }
        Duration sw = Duration.ofSeconds(this.raptorSearchParamsUsed.searchWindowInSeconds());
        if (this.firstRemovedItinerary != null) {
            Instant swStartTime = this.searchStartTime().plusSeconds(this.raptorSearchParamsUsed.earliestDepartureTime());
            boolean cropSWHead = this.request.doCropSearchWindowAtTail();
            Instant rmItineraryStartTime = this.firstRemovedItinerary.startTime().toInstant();
            return this.pagingSearchWindowAdjuster.decreaseSearchWindow(sw, swStartTime, rmItineraryStartTime, cropSWHead);
        }
        int nRequested = this.request.numItineraries();
        int nFound = (int)itineraries.stream().filter(it -> !it.isFlaggedForDeletion() && it.hasTransit()).count();
        return this.pagingSearchWindowAdjuster.increaseOrKeepSearchWindow(sw, nRequested, nFound);
    }

    private Instant searchStartTime() {
        return this.transitSearchTimeZero.toInstant();
    }

    private PagingSearchWindowAdjuster createPagingSearchWindowAdjuster(RouterConfig routerConfig) {
        DynamicSearchWindowCoefficients c = routerConfig.raptorTuningParameters().dynamicSearchWindowCoefficients();
        return new PagingSearchWindowAdjuster(c.minWinTimeMinutes(), c.maxWinTimeMinutes(), routerConfig.transitTuningParameters().pagingSearchWindowAdjustments());
    }
}

