/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import org.openstreetmap.osmosis.osmbinary.file.BlockInputStream;
import org.openstreetmap.osmosis.osmbinary.file.BlockReaderAdapter;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.graph_builder.ConfiguredDataSource;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmDefaultParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.openstreetmap.OpenStreetMapParser;
import org.opentripplanner.openstreetmap.OsmParserPhase;
import org.opentripplanner.openstreetmap.model.OSMProvider;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStreetMapProvider
implements OSMProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OpenStreetMapProvider.class);
    private final DataSource source;
    private final boolean cacheDataInMem;
    private final ZoneId zoneId;
    private boolean hasWarnedAboutMissingTimeZone = false;
    private final OsmTagMapper osmTagMapper;
    private final WayPropertySet wayPropertySet;
    private byte[] cachedBytes = null;

    public OpenStreetMapProvider(File file, boolean cacheDataInMem) {
        this(new FileDataSource(file, FileType.OSM), cacheDataInMem);
    }

    public OpenStreetMapProvider(FileDataSource fileDataSource, boolean cacheDataInMem) {
        this(new ConfiguredDataSource<OsmExtractParameters>(fileDataSource, new OsmExtractParametersBuilder().withSource(fileDataSource.uri()).build()), new OsmDefaultParameters(), cacheDataInMem);
    }

    public OpenStreetMapProvider(ConfiguredDataSource<OsmExtractParameters> osmExtractConfigConfiguredDataSource, OsmDefaultParameters defaultParameters, boolean cacheDataInMem) {
        this.source = osmExtractConfigConfiguredDataSource.dataSource();
        this.zoneId = osmExtractConfigConfiguredDataSource.config().timeZone().orElse(defaultParameters.timeZone);
        this.osmTagMapper = osmExtractConfigConfiguredDataSource.config().osmTagMapper().orElse(defaultParameters.osmOsmTagMapper);
        this.wayPropertySet = new WayPropertySet();
        this.osmTagMapper.populateProperties(this.wayPropertySet);
        this.cacheDataInMem = cacheDataInMem;
    }

    public void readOSM(OSMDatabase osmdb) {
        try {
            OpenStreetMapParser parser = new OpenStreetMapParser(osmdb, this);
            this.parsePhase(parser, OsmParserPhase.Relations);
            osmdb.doneFirstPhaseRelations();
            this.parsePhase(parser, OsmParserPhase.Ways);
            osmdb.doneSecondPhaseWays();
            this.parsePhase(parser, OsmParserPhase.Nodes);
            osmdb.doneThirdPhaseNodes();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error loading OSM from path " + this.source.path(), ex);
        }
    }

    public String toString() {
        return ToStringBuilder.of(OpenStreetMapProvider.class).addObj("source", this.source).addBool("cacheDataInMem", this.cacheDataInMem).toString();
    }

    public void checkInputs() {
        if (!this.source.exists()) {
            throw new RuntimeException("Can't read OSM path: " + this.source.path());
        }
    }

    private static InputStream track(OsmParserPhase phase, long size, InputStream inputStream) {
        return ProgressTracker.track("Parse OSM " + phase, 1000, size, inputStream, m -> LOG.info(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePhase(OpenStreetMapParser parser, OsmParserPhase phase) throws IOException {
        parser.setPhase(phase);
        BlockInputStream in = null;
        try {
            in = new BlockInputStream(this.createInputStream(phase), (BlockReaderAdapter)parser);
            in.process();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InputStream createInputStream(OsmParserPhase phase) {
        if (this.cacheDataInMem) {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.source.asBytes();
            }
            return OpenStreetMapProvider.track(phase, this.cachedBytes.length, new ByteArrayInputStream(this.cachedBytes));
        }
        return OpenStreetMapProvider.track(phase, this.source.size(), this.source.asInputStream());
    }

    @Override
    public ZoneId getZoneId() {
        if (this.zoneId == null && !this.hasWarnedAboutMissingTimeZone) {
            this.hasWarnedAboutMissingTimeZone = true;
            LOG.warn("Missing time zone for OSM source {} - time-restricted entities will not be created, please configure it in the build-config.json", (Object)this.source.uri());
        }
        return this.zoneId;
    }

    @Override
    public OsmTagMapper getOsmTagMapper() {
        return this.osmTagMapper;
    }

    @Override
    public WayPropertySet getWayPropertySet() {
        return this.wayPropertySet;
    }
}

