/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.issues.DayTypeScheduleIsEmpty;
import org.opentripplanner.netex.mapping.calendar.DayOfWeekMapper;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeAssignment;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingPeriod;
import org.rutebanken.netex.model.PropertyOfDay;

public class DayTypeAssignmentMapper {
    private final DayType dayType;
    private final ReadOnlyHierarchicalMapById<OperatingDay> operatingDays;
    private final ReadOnlyHierarchicalMapById<OperatingPeriod> operatingPeriods;
    private final Set<LocalDate> dates = new HashSet<LocalDate>();
    private final Set<LocalDate> datesToRemove = new HashSet<LocalDate>();

    private DayTypeAssignmentMapper(DayType dayType, ReadOnlyHierarchicalMapById<OperatingDay> operatingDays, ReadOnlyHierarchicalMapById<OperatingPeriod> operatingPeriods) {
        this.dayType = dayType;
        this.operatingDays = operatingDays;
        this.operatingPeriods = operatingPeriods;
    }

    public static Map<String, Set<LocalDate>> mapDayTypes(ReadOnlyHierarchicalMapById<DayType> dayTypes, ReadOnlyHierarchicalMap<String, Collection<DayTypeAssignment>> assignments, ReadOnlyHierarchicalMapById<OperatingDay> operatingDays, ReadOnlyHierarchicalMapById<OperatingPeriod> operatingPeriods, DataImportIssueStore issueStore) {
        HashMap<String, Set<LocalDate>> result = new HashMap<String, Set<LocalDate>>();
        for (DayType dayType : dayTypes.localValues()) {
            DayTypeAssignmentMapper mapper = new DayTypeAssignmentMapper(dayType, operatingDays, operatingPeriods);
            for (DayTypeAssignment it : assignments.lookup(dayType.getId())) {
                mapper.map(it);
            }
            Set<LocalDate> dates = mapper.mergeAndMapDates();
            if (dates.isEmpty()) {
                issueStore.add(new DayTypeScheduleIsEmpty(dayType.getId()));
            }
            result.put(dayType.getId(), dates);
        }
        return result;
    }

    private static boolean isDayTypeAvailableForAssigment(DayTypeAssignment dta) {
        if (dta.isIsAvailable() == null) {
            return true;
        }
        return dta.isIsAvailable();
    }

    private static Set<DayOfWeek> daysOfWeekForDayType(DayType dayType) {
        EnumSet<DayOfWeek> result = EnumSet.noneOf(DayOfWeek.class);
        if (dayType.getProperties() != null) {
            List propertyOfDays = dayType.getProperties().getPropertyOfDay();
            for (PropertyOfDay p : propertyOfDays) {
                result.addAll(DayOfWeekMapper.mapDayOfWeeks(p.getDaysOfWeek()));
            }
        }
        return result;
    }

    private void map(DayTypeAssignment dayTypeAssignment) {
        if (dayTypeAssignment.getDate() != null) {
            this.addSpecificDate(dayTypeAssignment);
        } else if (dayTypeAssignment.getOperatingPeriodRef() != null) {
            this.addOperationPeriod(dayTypeAssignment);
        } else if (dayTypeAssignment.getOperatingDayRef() != null) {
            OperatingDay opd = (OperatingDay)this.operatingDays.lookup(dayTypeAssignment.getOperatingDayRef().getRef());
            this.addDate(true, opd.getCalendarDate());
        }
    }

    private Set<LocalDate> mergeAndMapDates() {
        this.dates.removeAll(this.datesToRemove);
        return new HashSet<LocalDate>(this.dates);
    }

    private void addSpecificDate(DayTypeAssignment dayTypeAssignment) {
        this.addDate(DayTypeAssignmentMapper.isDayTypeAvailableForAssigment(dayTypeAssignment), dayTypeAssignment.getDate());
    }

    private void addOperationPeriod(DayTypeAssignment dayTypeAssignment) {
        boolean isAvailable = DayTypeAssignmentMapper.isDayTypeAvailableForAssigment(dayTypeAssignment);
        String ref = dayTypeAssignment.getOperatingPeriodRef().getRef();
        OperatingPeriod period = (OperatingPeriod)this.operatingPeriods.lookup(ref);
        if (period != null) {
            Set<DayOfWeek> daysOfWeek = DayTypeAssignmentMapper.daysOfWeekForDayType(this.dayType);
            LocalDateTime endDate = period.getToDate().plusDays(1L);
            LocalDateTime date = period.getFromDate();
            while (date.isBefore(endDate)) {
                if (daysOfWeek.contains(date.getDayOfWeek())) {
                    this.addDate(isAvailable, date);
                }
                date = date.plusDays(1L);
            }
        }
    }

    private void addDate(boolean isAvailable, LocalDateTime date) {
        if (isAvailable) {
            this.dates.add(date.toLocalDate());
        } else {
            this.datesToRemove.add(date.toLocalDate());
        }
    }
}

