/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.MainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.TransportSubmodeStructure;

class TransportModeMapper {
    TransportModeMapper() {
    }

    public MainAndSubMode map(AllVehicleModesOfTransportEnumeration netexMode, TransportSubmodeStructure submode) throws UnsupportedModeException {
        if (submode == null) {
            return new MainAndSubMode(this.mapAllVehicleModesOfTransport(netexMode));
        }
        return this.getSubmodeAsString(submode);
    }

    private TransitMode mapAllVehicleModesOfTransport(AllVehicleModesOfTransportEnumeration mode) throws UnsupportedModeException {
        if (mode == null) {
            throw new UnsupportedModeException(null);
        }
        return switch (mode) {
            case AllVehicleModesOfTransportEnumeration.AIR -> TransitMode.AIRPLANE;
            case AllVehicleModesOfTransportEnumeration.BUS, AllVehicleModesOfTransportEnumeration.TAXI -> TransitMode.BUS;
            case AllVehicleModesOfTransportEnumeration.CABLEWAY -> TransitMode.CABLE_CAR;
            case AllVehicleModesOfTransportEnumeration.COACH -> TransitMode.COACH;
            case AllVehicleModesOfTransportEnumeration.FUNICULAR -> TransitMode.FUNICULAR;
            case AllVehicleModesOfTransportEnumeration.METRO -> TransitMode.SUBWAY;
            case AllVehicleModesOfTransportEnumeration.RAIL -> TransitMode.RAIL;
            case AllVehicleModesOfTransportEnumeration.TRAM -> TransitMode.TRAM;
            case AllVehicleModesOfTransportEnumeration.WATER -> TransitMode.FERRY;
            default -> throw new UnsupportedModeException(mode);
        };
    }

    private MainAndSubMode getSubmodeAsString(TransportSubmodeStructure submode) {
        if (submode.getAirSubmode() != null) {
            return new MainAndSubMode(TransitMode.AIRPLANE, submode.getAirSubmode().value());
        }
        if (submode.getBusSubmode() != null) {
            return new MainAndSubMode(TransitMode.BUS, submode.getBusSubmode().value());
        }
        if (submode.getTelecabinSubmode() != null) {
            return new MainAndSubMode(TransitMode.GONDOLA, submode.getTelecabinSubmode().value());
        }
        if (submode.getCoachSubmode() != null) {
            return new MainAndSubMode(TransitMode.COACH, submode.getCoachSubmode().value());
        }
        if (submode.getFunicularSubmode() != null) {
            return new MainAndSubMode(TransitMode.FUNICULAR, submode.getFunicularSubmode().value());
        }
        if (submode.getMetroSubmode() != null) {
            return new MainAndSubMode(TransitMode.SUBWAY, submode.getMetroSubmode().value());
        }
        if (submode.getRailSubmode() != null) {
            return new MainAndSubMode(TransitMode.RAIL, submode.getRailSubmode().value());
        }
        if (submode.getTramSubmode() != null) {
            return new MainAndSubMode(TransitMode.TRAM, submode.getTramSubmode().value());
        }
        if (submode.getWaterSubmode() != null) {
            return new MainAndSubMode(TransitMode.FERRY, submode.getWaterSubmode().value());
        }
        throw new IllegalArgumentException();
    }

    static class UnsupportedModeException
    extends Exception {
        final AllVehicleModesOfTransportEnumeration mode;

        public UnsupportedModeException(AllVehicleModesOfTransportEnumeration mode) {
            this.mode = mode;
        }
    }
}

